/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.labor;

import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.labor.AsyncRawWorkweekConfigsClient;
import com.squareup.square.labor.types.ListWorkweekConfigsRequest;
import com.squareup.square.labor.types.UpdateWorkweekConfigRequest;
import com.squareup.square.types.UpdateWorkweekConfigResponse;
import com.squareup.square.types.WorkweekConfig;
import java.util.concurrent.CompletableFuture;

public class AsyncWorkweekConfigsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawWorkweekConfigsClient rawClient;

    public AsyncWorkweekConfigsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawWorkweekConfigsClient(clientOptions);
    }

    public AsyncRawWorkweekConfigsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<SyncPagingIterable<WorkweekConfig>> list() {
        return this.rawClient.list().thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<WorkweekConfig>> list(ListWorkweekConfigsRequest request) {
        return this.rawClient.list(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<WorkweekConfig>> list(ListWorkweekConfigsRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<UpdateWorkweekConfigResponse> get(UpdateWorkweekConfigRequest request) {
        return this.rawClient.get(request).thenApply(response -> (UpdateWorkweekConfigResponse)response.body());
    }

    public CompletableFuture<UpdateWorkweekConfigResponse> get(UpdateWorkweekConfigRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (UpdateWorkweekConfigResponse)response.body());
    }
}

