/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.locations;

import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.locations.AsyncRawCustomAttributeDefinitionsClient;
import com.squareup.square.locations.types.CreateLocationCustomAttributeDefinitionRequest;
import com.squareup.square.locations.types.DeleteCustomAttributeDefinitionsRequest;
import com.squareup.square.locations.types.GetCustomAttributeDefinitionsRequest;
import com.squareup.square.locations.types.ListCustomAttributeDefinitionsRequest;
import com.squareup.square.locations.types.UpdateLocationCustomAttributeDefinitionRequest;
import com.squareup.square.types.CreateLocationCustomAttributeDefinitionResponse;
import com.squareup.square.types.CustomAttributeDefinition;
import com.squareup.square.types.DeleteLocationCustomAttributeDefinitionResponse;
import com.squareup.square.types.RetrieveLocationCustomAttributeDefinitionResponse;
import com.squareup.square.types.UpdateLocationCustomAttributeDefinitionResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncCustomAttributeDefinitionsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawCustomAttributeDefinitionsClient rawClient;

    public AsyncCustomAttributeDefinitionsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawCustomAttributeDefinitionsClient(clientOptions);
    }

    public AsyncRawCustomAttributeDefinitionsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<SyncPagingIterable<CustomAttributeDefinition>> list() {
        return this.rawClient.list().thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<CustomAttributeDefinition>> list(ListCustomAttributeDefinitionsRequest request) {
        return this.rawClient.list(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<CustomAttributeDefinition>> list(ListCustomAttributeDefinitionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<CreateLocationCustomAttributeDefinitionResponse> create(CreateLocationCustomAttributeDefinitionRequest request) {
        return this.rawClient.create(request).thenApply(response -> (CreateLocationCustomAttributeDefinitionResponse)response.body());
    }

    public CompletableFuture<CreateLocationCustomAttributeDefinitionResponse> create(CreateLocationCustomAttributeDefinitionRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (CreateLocationCustomAttributeDefinitionResponse)response.body());
    }

    public CompletableFuture<RetrieveLocationCustomAttributeDefinitionResponse> get(GetCustomAttributeDefinitionsRequest request) {
        return this.rawClient.get(request).thenApply(response -> (RetrieveLocationCustomAttributeDefinitionResponse)response.body());
    }

    public CompletableFuture<RetrieveLocationCustomAttributeDefinitionResponse> get(GetCustomAttributeDefinitionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (RetrieveLocationCustomAttributeDefinitionResponse)response.body());
    }

    public CompletableFuture<UpdateLocationCustomAttributeDefinitionResponse> update(UpdateLocationCustomAttributeDefinitionRequest request) {
        return this.rawClient.update(request).thenApply(response -> (UpdateLocationCustomAttributeDefinitionResponse)response.body());
    }

    public CompletableFuture<UpdateLocationCustomAttributeDefinitionResponse> update(UpdateLocationCustomAttributeDefinitionRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).thenApply(response -> (UpdateLocationCustomAttributeDefinitionResponse)response.body());
    }

    public CompletableFuture<DeleteLocationCustomAttributeDefinitionResponse> delete(DeleteCustomAttributeDefinitionsRequest request) {
        return this.rawClient.delete(request).thenApply(response -> (DeleteLocationCustomAttributeDefinitionResponse)response.body());
    }

    public CompletableFuture<DeleteLocationCustomAttributeDefinitionResponse> delete(DeleteCustomAttributeDefinitionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(request, requestOptions).thenApply(response -> (DeleteLocationCustomAttributeDefinitionResponse)response.body());
    }
}

