/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.locations;

import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.locations.AsyncRawTransactionsClient;
import com.squareup.square.locations.types.CaptureTransactionsRequest;
import com.squareup.square.locations.types.GetTransactionsRequest;
import com.squareup.square.locations.types.ListTransactionsRequest;
import com.squareup.square.locations.types.VoidTransactionsRequest;
import com.squareup.square.types.CaptureTransactionResponse;
import com.squareup.square.types.GetTransactionResponse;
import com.squareup.square.types.ListTransactionsResponse;
import com.squareup.square.types.VoidTransactionResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncTransactionsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawTransactionsClient rawClient;

    public AsyncTransactionsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawTransactionsClient(clientOptions);
    }

    public AsyncRawTransactionsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<ListTransactionsResponse> list(ListTransactionsRequest request) {
        return this.rawClient.list(request).thenApply(response -> (ListTransactionsResponse)response.body());
    }

    public CompletableFuture<ListTransactionsResponse> list(ListTransactionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (ListTransactionsResponse)response.body());
    }

    public CompletableFuture<GetTransactionResponse> get(GetTransactionsRequest request) {
        return this.rawClient.get(request).thenApply(response -> (GetTransactionResponse)response.body());
    }

    public CompletableFuture<GetTransactionResponse> get(GetTransactionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (GetTransactionResponse)response.body());
    }

    public CompletableFuture<CaptureTransactionResponse> capture(CaptureTransactionsRequest request) {
        return this.rawClient.capture(request).thenApply(response -> (CaptureTransactionResponse)response.body());
    }

    public CompletableFuture<CaptureTransactionResponse> capture(CaptureTransactionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.capture(request, requestOptions).thenApply(response -> (CaptureTransactionResponse)response.body());
    }

    public CompletableFuture<VoidTransactionResponse> void_(VoidTransactionsRequest request) {
        return this.rawClient.void_(request).thenApply(response -> (VoidTransactionResponse)response.body());
    }

    public CompletableFuture<VoidTransactionResponse> void_(VoidTransactionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.void_(request, requestOptions).thenApply(response -> (VoidTransactionResponse)response.body());
    }
}

