/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.locations.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CustomAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpsertLocationCustomAttributeRequest {
    private final String locationId;
    private final String key;
    private final CustomAttribute customAttribute;
    private final Optional<String> idempotencyKey;
    private final Map<String, Object> additionalProperties;

    private UpsertLocationCustomAttributeRequest(String locationId, String key, CustomAttribute customAttribute, Optional<String> idempotencyKey, Map<String, Object> additionalProperties) {
        this.locationId = locationId;
        this.key = key;
        this.customAttribute = customAttribute;
        this.idempotencyKey = idempotencyKey;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="location_id")
    public String getLocationId() {
        return this.locationId;
    }

    @JsonProperty(value="key")
    public String getKey() {
        return this.key;
    }

    @JsonProperty(value="custom_attribute")
    public CustomAttribute getCustomAttribute() {
        return this.customAttribute;
    }

    @JsonIgnore
    public Optional<String> getIdempotencyKey() {
        if (this.idempotencyKey == null) {
            return Optional.empty();
        }
        return this.idempotencyKey;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="idempotency_key")
    private Optional<String> _getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpsertLocationCustomAttributeRequest && this.equalTo((UpsertLocationCustomAttributeRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpsertLocationCustomAttributeRequest other) {
        return this.locationId.equals(other.locationId) && this.key.equals(other.key) && this.customAttribute.equals(other.customAttribute) && this.idempotencyKey.equals(other.idempotencyKey);
    }

    public int hashCode() {
        return Objects.hash(this.locationId, this.key, this.customAttribute, this.idempotencyKey);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LocationIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements LocationIdStage,
    KeyStage,
    CustomAttributeStage,
    _FinalStage {
        private String locationId;
        private String key;
        private CustomAttribute customAttribute;
        private Optional<String> idempotencyKey = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpsertLocationCustomAttributeRequest other) {
            this.locationId(other.getLocationId());
            this.key(other.getKey());
            this.customAttribute(other.getCustomAttribute());
            this.idempotencyKey(other.getIdempotencyKey());
            return this;
        }

        @Override
        @JsonSetter(value="location_id")
        public KeyStage locationId(@NotNull String locationId) {
            this.locationId = Objects.requireNonNull(locationId, "locationId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="key")
        public CustomAttributeStage key(@NotNull String key) {
            this.key = Objects.requireNonNull(key, "key must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="custom_attribute")
        public _FinalStage customAttribute(@NotNull CustomAttribute customAttribute) {
            this.customAttribute = Objects.requireNonNull(customAttribute, "customAttribute must not be null");
            return this;
        }

        @Override
        public _FinalStage idempotencyKey(Nullable<String> idempotencyKey) {
            this.idempotencyKey = idempotencyKey.isNull() ? null : (idempotencyKey.isEmpty() ? Optional.empty() : Optional.of(idempotencyKey.get()));
            return this;
        }

        @Override
        public _FinalStage idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = Optional.ofNullable(idempotencyKey);
            return this;
        }

        @Override
        @JsonSetter(value="idempotency_key", nulls=Nulls.SKIP)
        public _FinalStage idempotencyKey(Optional<String> idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        @Override
        public UpsertLocationCustomAttributeRequest build() {
            return new UpsertLocationCustomAttributeRequest(this.locationId, this.key, this.customAttribute, this.idempotencyKey, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpsertLocationCustomAttributeRequest build();

        public _FinalStage idempotencyKey(Optional<String> var1);

        public _FinalStage idempotencyKey(String var1);

        public _FinalStage idempotencyKey(Nullable<String> var1);
    }

    public static interface CustomAttributeStage {
        public _FinalStage customAttribute(@NotNull CustomAttribute var1);
    }

    public static interface KeyStage {
        public CustomAttributeStage key(@NotNull String var1);
    }

    public static interface LocationIdStage {
        public KeyStage locationId(@NotNull String var1);

        public Builder from(UpsertLocationCustomAttributeRequest var1);
    }
}

