/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.loyalty;

import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.loyalty.RawAccountsClient;
import com.squareup.square.loyalty.types.AccumulateLoyaltyPointsRequest;
import com.squareup.square.loyalty.types.AdjustLoyaltyPointsRequest;
import com.squareup.square.loyalty.types.CreateLoyaltyAccountRequest;
import com.squareup.square.loyalty.types.GetAccountsRequest;
import com.squareup.square.loyalty.types.SearchLoyaltyAccountsRequest;
import com.squareup.square.types.AccumulateLoyaltyPointsResponse;
import com.squareup.square.types.AdjustLoyaltyPointsResponse;
import com.squareup.square.types.CreateLoyaltyAccountResponse;
import com.squareup.square.types.GetLoyaltyAccountResponse;
import com.squareup.square.types.SearchLoyaltyAccountsResponse;

public class AccountsClient {
    protected final ClientOptions clientOptions;
    private final RawAccountsClient rawClient;

    public AccountsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawAccountsClient(clientOptions);
    }

    public RawAccountsClient withRawResponse() {
        return this.rawClient;
    }

    public CreateLoyaltyAccountResponse create(CreateLoyaltyAccountRequest request) {
        return this.rawClient.create(request).body();
    }

    public CreateLoyaltyAccountResponse create(CreateLoyaltyAccountRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).body();
    }

    public SearchLoyaltyAccountsResponse search() {
        return this.rawClient.search().body();
    }

    public SearchLoyaltyAccountsResponse search(SearchLoyaltyAccountsRequest request) {
        return this.rawClient.search(request).body();
    }

    public SearchLoyaltyAccountsResponse search(SearchLoyaltyAccountsRequest request, RequestOptions requestOptions) {
        return this.rawClient.search(request, requestOptions).body();
    }

    public GetLoyaltyAccountResponse get(GetAccountsRequest request) {
        return this.rawClient.get(request).body();
    }

    public GetLoyaltyAccountResponse get(GetAccountsRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).body();
    }

    public AccumulateLoyaltyPointsResponse accumulatePoints(AccumulateLoyaltyPointsRequest request) {
        return this.rawClient.accumulatePoints(request).body();
    }

    public AccumulateLoyaltyPointsResponse accumulatePoints(AccumulateLoyaltyPointsRequest request, RequestOptions requestOptions) {
        return this.rawClient.accumulatePoints(request, requestOptions).body();
    }

    public AdjustLoyaltyPointsResponse adjust(AdjustLoyaltyPointsRequest request) {
        return this.rawClient.adjust(request).body();
    }

    public AdjustLoyaltyPointsResponse adjust(AdjustLoyaltyPointsRequest request, RequestOptions requestOptions) {
        return this.rawClient.adjust(request, requestOptions).body();
    }
}

