/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.loyalty;

import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.Suppliers;
import com.squareup.square.loyalty.AsyncRawProgramsClient;
import com.squareup.square.loyalty.programs.AsyncPromotionsClient;
import com.squareup.square.loyalty.types.CalculateLoyaltyPointsRequest;
import com.squareup.square.loyalty.types.GetProgramsRequest;
import com.squareup.square.types.CalculateLoyaltyPointsResponse;
import com.squareup.square.types.GetLoyaltyProgramResponse;
import com.squareup.square.types.ListLoyaltyProgramsResponse;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class AsyncProgramsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawProgramsClient rawClient;
    protected final Supplier<AsyncPromotionsClient> promotionsClient;

    public AsyncProgramsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawProgramsClient(clientOptions);
        this.promotionsClient = Suppliers.memoize(() -> new AsyncPromotionsClient(clientOptions));
    }

    public AsyncRawProgramsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<ListLoyaltyProgramsResponse> list() {
        return this.rawClient.list().thenApply(response -> (ListLoyaltyProgramsResponse)response.body());
    }

    public CompletableFuture<ListLoyaltyProgramsResponse> list(RequestOptions requestOptions) {
        return this.rawClient.list(requestOptions).thenApply(response -> (ListLoyaltyProgramsResponse)response.body());
    }

    public CompletableFuture<GetLoyaltyProgramResponse> get(GetProgramsRequest request) {
        return this.rawClient.get(request).thenApply(response -> (GetLoyaltyProgramResponse)response.body());
    }

    public CompletableFuture<GetLoyaltyProgramResponse> get(GetProgramsRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (GetLoyaltyProgramResponse)response.body());
    }

    public CompletableFuture<CalculateLoyaltyPointsResponse> calculate(CalculateLoyaltyPointsRequest request) {
        return this.rawClient.calculate(request).thenApply(response -> (CalculateLoyaltyPointsResponse)response.body());
    }

    public CompletableFuture<CalculateLoyaltyPointsResponse> calculate(CalculateLoyaltyPointsRequest request, RequestOptions requestOptions) {
        return this.rawClient.calculate(request, requestOptions).thenApply(response -> (CalculateLoyaltyPointsResponse)response.body());
    }

    public AsyncPromotionsClient promotions() {
        return this.promotionsClient.get();
    }
}

