/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.loyalty.programs;

import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.loyalty.programs.RawPromotionsClient;
import com.squareup.square.loyalty.programs.types.CancelPromotionsRequest;
import com.squareup.square.loyalty.programs.types.CreateLoyaltyPromotionRequest;
import com.squareup.square.loyalty.programs.types.GetPromotionsRequest;
import com.squareup.square.loyalty.programs.types.ListPromotionsRequest;
import com.squareup.square.types.CancelLoyaltyPromotionResponse;
import com.squareup.square.types.CreateLoyaltyPromotionResponse;
import com.squareup.square.types.GetLoyaltyPromotionResponse;
import com.squareup.square.types.LoyaltyPromotion;

public class PromotionsClient {
    protected final ClientOptions clientOptions;
    private final RawPromotionsClient rawClient;

    public PromotionsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawPromotionsClient(clientOptions);
    }

    public RawPromotionsClient withRawResponse() {
        return this.rawClient;
    }

    public SyncPagingIterable<LoyaltyPromotion> list(ListPromotionsRequest request) {
        return this.rawClient.list(request).body();
    }

    public SyncPagingIterable<LoyaltyPromotion> list(ListPromotionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).body();
    }

    public CreateLoyaltyPromotionResponse create(CreateLoyaltyPromotionRequest request) {
        return this.rawClient.create(request).body();
    }

    public CreateLoyaltyPromotionResponse create(CreateLoyaltyPromotionRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).body();
    }

    public GetLoyaltyPromotionResponse get(GetPromotionsRequest request) {
        return this.rawClient.get(request).body();
    }

    public GetLoyaltyPromotionResponse get(GetPromotionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).body();
    }

    public CancelLoyaltyPromotionResponse cancel(CancelPromotionsRequest request) {
        return this.rawClient.cancel(request).body();
    }

    public CancelLoyaltyPromotionResponse cancel(CancelPromotionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.cancel(request, requestOptions).body();
    }
}

