/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.loyalty.programs;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.MediaTypes;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.core.QueryStringMapper;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SquareApiException;
import com.squareup.square.core.SquareClientHttpResponse;
import com.squareup.square.core.SquareException;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.loyalty.programs.types.CancelPromotionsRequest;
import com.squareup.square.loyalty.programs.types.CreateLoyaltyPromotionRequest;
import com.squareup.square.loyalty.programs.types.GetPromotionsRequest;
import com.squareup.square.loyalty.programs.types.ListPromotionsRequest;
import com.squareup.square.types.CancelLoyaltyPromotionResponse;
import com.squareup.square.types.CreateLoyaltyPromotionResponse;
import com.squareup.square.types.GetLoyaltyPromotionResponse;
import com.squareup.square.types.ListLoyaltyPromotionsResponse;
import com.squareup.square.types.LoyaltyPromotion;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawPromotionsClient {
    protected final ClientOptions clientOptions;

    public RawPromotionsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public SquareClientHttpResponse<SyncPagingIterable<LoyaltyPromotion>> list(ListPromotionsRequest request) {
        return this.list(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<SyncPagingIterable<LoyaltyPromotion>> list(ListPromotionsRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/loyalty/programs").addPathSegment(request.getProgramId()).addPathSegments("promotions");
        if (request.getStatus().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "status", request.getStatus().get(), false);
        }
        if (request.getCursor().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "cursor", request.getCursor().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                ListLoyaltyPromotionsResponse parsedResponse = (ListLoyaltyPromotionsResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListLoyaltyPromotionsResponse.class);
                Optional<String> startingAfter = parsedResponse.getCursor();
                ListPromotionsRequest nextRequest = ListPromotionsRequest.builder().from(request).cursor(startingAfter).build();
                List result = parsedResponse.getLoyaltyPromotions().orElse(Collections.emptyList());
                SquareClientHttpResponse<SyncPagingIterable<LoyaltyPromotion>> squareClientHttpResponse = new SquareClientHttpResponse<SyncPagingIterable<LoyaltyPromotion>>(new SyncPagingIterable(startingAfter.isPresent(), result, () -> this.list(nextRequest, requestOptions).body()), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<CreateLoyaltyPromotionResponse> create(CreateLoyaltyPromotionRequest request) {
        return this.create(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<CreateLoyaltyPromotionResponse> create(CreateLoyaltyPromotionRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/loyalty/programs").addPathSegment(request.getProgramId()).addPathSegments("promotions").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<CreateLoyaltyPromotionResponse> squareClientHttpResponse = new SquareClientHttpResponse<CreateLoyaltyPromotionResponse>((CreateLoyaltyPromotionResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CreateLoyaltyPromotionResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<GetLoyaltyPromotionResponse> get(GetPromotionsRequest request) {
        return this.get(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<GetLoyaltyPromotionResponse> get(GetPromotionsRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/loyalty/programs").addPathSegment(request.getProgramId()).addPathSegments("promotions").addPathSegment(request.getPromotionId()).build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<GetLoyaltyPromotionResponse> squareClientHttpResponse = new SquareClientHttpResponse<GetLoyaltyPromotionResponse>((GetLoyaltyPromotionResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), GetLoyaltyPromotionResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<CancelLoyaltyPromotionResponse> cancel(CancelPromotionsRequest request) {
        return this.cancel(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<CancelLoyaltyPromotionResponse> cancel(CancelPromotionsRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/loyalty/programs").addPathSegment(request.getProgramId()).addPathSegments("promotions").addPathSegment(request.getPromotionId()).addPathSegments("cancel").build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("POST", RequestBody.create((String)"", null)).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<CancelLoyaltyPromotionResponse> squareClientHttpResponse = new SquareClientHttpResponse<CancelLoyaltyPromotionResponse>((CancelLoyaltyPromotionResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CancelLoyaltyPromotionResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }
}

