/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.loyalty.programs.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.LoyaltyPromotionStatus;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListPromotionsRequest {
    private final String programId;
    private final Optional<LoyaltyPromotionStatus> status;
    private final Optional<String> cursor;
    private final Optional<Integer> limit;
    private final Map<String, Object> additionalProperties;

    private ListPromotionsRequest(String programId, Optional<LoyaltyPromotionStatus> status, Optional<String> cursor, Optional<Integer> limit, Map<String, Object> additionalProperties) {
        this.programId = programId;
        this.status = status;
        this.cursor = cursor;
        this.limit = limit;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="program_id")
    public String getProgramId() {
        return this.programId;
    }

    @JsonIgnore
    public Optional<LoyaltyPromotionStatus> getStatus() {
        if (this.status == null) {
            return Optional.empty();
        }
        return this.status;
    }

    @JsonIgnore
    public Optional<String> getCursor() {
        if (this.cursor == null) {
            return Optional.empty();
        }
        return this.cursor;
    }

    @JsonIgnore
    public Optional<Integer> getLimit() {
        if (this.limit == null) {
            return Optional.empty();
        }
        return this.limit;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="status")
    private Optional<LoyaltyPromotionStatus> _getStatus() {
        return this.status;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="cursor")
    private Optional<String> _getCursor() {
        return this.cursor;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="limit")
    private Optional<Integer> _getLimit() {
        return this.limit;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListPromotionsRequest && this.equalTo((ListPromotionsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListPromotionsRequest other) {
        return this.programId.equals(other.programId) && this.status.equals(other.status) && this.cursor.equals(other.cursor) && this.limit.equals(other.limit);
    }

    public int hashCode() {
        return Objects.hash(this.programId, this.status, this.cursor, this.limit);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ProgramIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ProgramIdStage,
    _FinalStage {
        private String programId;
        private Optional<Integer> limit = Optional.empty();
        private Optional<String> cursor = Optional.empty();
        private Optional<LoyaltyPromotionStatus> status = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ListPromotionsRequest other) {
            this.programId(other.getProgramId());
            this.status(other.getStatus());
            this.cursor(other.getCursor());
            this.limit(other.getLimit());
            return this;
        }

        @Override
        @JsonSetter(value="program_id")
        public _FinalStage programId(@NotNull String programId) {
            this.programId = Objects.requireNonNull(programId, "programId must not be null");
            return this;
        }

        @Override
        public _FinalStage limit(Nullable<Integer> limit) {
            this.limit = limit.isNull() ? null : (limit.isEmpty() ? Optional.empty() : Optional.of(limit.get()));
            return this;
        }

        @Override
        public _FinalStage limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @Override
        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public _FinalStage limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public _FinalStage cursor(Nullable<String> cursor) {
            this.cursor = cursor.isNull() ? null : (cursor.isEmpty() ? Optional.empty() : Optional.of(cursor.get()));
            return this;
        }

        @Override
        public _FinalStage cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        @Override
        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public _FinalStage cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        @Override
        public _FinalStage status(Nullable<LoyaltyPromotionStatus> status) {
            this.status = status.isNull() ? null : (status.isEmpty() ? Optional.empty() : Optional.of(status.get()));
            return this;
        }

        @Override
        public _FinalStage status(LoyaltyPromotionStatus status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @Override
        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public _FinalStage status(Optional<LoyaltyPromotionStatus> status) {
            this.status = status;
            return this;
        }

        @Override
        public ListPromotionsRequest build() {
            return new ListPromotionsRequest(this.programId, this.status, this.cursor, this.limit, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ListPromotionsRequest build();

        public _FinalStage status(Optional<LoyaltyPromotionStatus> var1);

        public _FinalStage status(LoyaltyPromotionStatus var1);

        public _FinalStage status(Nullable<LoyaltyPromotionStatus> var1);

        public _FinalStage cursor(Optional<String> var1);

        public _FinalStage cursor(String var1);

        public _FinalStage cursor(Nullable<String> var1);

        public _FinalStage limit(Optional<Integer> var1);

        public _FinalStage limit(Integer var1);

        public _FinalStage limit(Nullable<Integer> var1);
    }

    public static interface ProgramIdStage {
        public _FinalStage programId(@NotNull String var1);

        public Builder from(ListPromotionsRequest var1);
    }
}

