/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.loyalty.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.LoyaltyEventAccumulatePoints;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class AccumulateLoyaltyPointsRequest {
    private final String accountId;
    private final LoyaltyEventAccumulatePoints accumulatePoints;
    private final String idempotencyKey;
    private final String locationId;
    private final Map<String, Object> additionalProperties;

    private AccumulateLoyaltyPointsRequest(String accountId, LoyaltyEventAccumulatePoints accumulatePoints, String idempotencyKey, String locationId, Map<String, Object> additionalProperties) {
        this.accountId = accountId;
        this.accumulatePoints = accumulatePoints;
        this.idempotencyKey = idempotencyKey;
        this.locationId = locationId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="account_id")
    public String getAccountId() {
        return this.accountId;
    }

    @JsonProperty(value="accumulate_points")
    public LoyaltyEventAccumulatePoints getAccumulatePoints() {
        return this.accumulatePoints;
    }

    @JsonProperty(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonProperty(value="location_id")
    public String getLocationId() {
        return this.locationId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AccumulateLoyaltyPointsRequest && this.equalTo((AccumulateLoyaltyPointsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AccumulateLoyaltyPointsRequest other) {
        return this.accountId.equals(other.accountId) && this.accumulatePoints.equals(other.accumulatePoints) && this.idempotencyKey.equals(other.idempotencyKey) && this.locationId.equals(other.locationId);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.accumulatePoints, this.idempotencyKey, this.locationId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AccountIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements AccountIdStage,
    AccumulatePointsStage,
    IdempotencyKeyStage,
    LocationIdStage,
    _FinalStage {
        private String accountId;
        private LoyaltyEventAccumulatePoints accumulatePoints;
        private String idempotencyKey;
        private String locationId;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(AccumulateLoyaltyPointsRequest other) {
            this.accountId(other.getAccountId());
            this.accumulatePoints(other.getAccumulatePoints());
            this.idempotencyKey(other.getIdempotencyKey());
            this.locationId(other.getLocationId());
            return this;
        }

        @Override
        @JsonSetter(value="account_id")
        public AccumulatePointsStage accountId(@NotNull String accountId) {
            this.accountId = Objects.requireNonNull(accountId, "accountId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="accumulate_points")
        public IdempotencyKeyStage accumulatePoints(@NotNull LoyaltyEventAccumulatePoints accumulatePoints) {
            this.accumulatePoints = Objects.requireNonNull(accumulatePoints, "accumulatePoints must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="idempotency_key")
        public LocationIdStage idempotencyKey(@NotNull String idempotencyKey) {
            this.idempotencyKey = Objects.requireNonNull(idempotencyKey, "idempotencyKey must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="location_id")
        public _FinalStage locationId(@NotNull String locationId) {
            this.locationId = Objects.requireNonNull(locationId, "locationId must not be null");
            return this;
        }

        @Override
        public AccumulateLoyaltyPointsRequest build() {
            return new AccumulateLoyaltyPointsRequest(this.accountId, this.accumulatePoints, this.idempotencyKey, this.locationId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public AccumulateLoyaltyPointsRequest build();
    }

    public static interface LocationIdStage {
        public _FinalStage locationId(@NotNull String var1);
    }

    public static interface IdempotencyKeyStage {
        public LocationIdStage idempotencyKey(@NotNull String var1);
    }

    public static interface AccumulatePointsStage {
        public IdempotencyKeyStage accumulatePoints(@NotNull LoyaltyEventAccumulatePoints var1);
    }

    public static interface AccountIdStage {
        public AccumulatePointsStage accountId(@NotNull String var1);

        public Builder from(AccumulateLoyaltyPointsRequest var1);
    }
}

