/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.loyalty.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Money;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CalculateLoyaltyPointsRequest {
    private final String programId;
    private final Optional<String> orderId;
    private final Optional<Money> transactionAmountMoney;
    private final Optional<String> loyaltyAccountId;
    private final Map<String, Object> additionalProperties;

    private CalculateLoyaltyPointsRequest(String programId, Optional<String> orderId, Optional<Money> transactionAmountMoney, Optional<String> loyaltyAccountId, Map<String, Object> additionalProperties) {
        this.programId = programId;
        this.orderId = orderId;
        this.transactionAmountMoney = transactionAmountMoney;
        this.loyaltyAccountId = loyaltyAccountId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="program_id")
    public String getProgramId() {
        return this.programId;
    }

    @JsonIgnore
    public Optional<String> getOrderId() {
        if (this.orderId == null) {
            return Optional.empty();
        }
        return this.orderId;
    }

    @JsonProperty(value="transaction_amount_money")
    public Optional<Money> getTransactionAmountMoney() {
        return this.transactionAmountMoney;
    }

    @JsonIgnore
    public Optional<String> getLoyaltyAccountId() {
        if (this.loyaltyAccountId == null) {
            return Optional.empty();
        }
        return this.loyaltyAccountId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="order_id")
    private Optional<String> _getOrderId() {
        return this.orderId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="loyalty_account_id")
    private Optional<String> _getLoyaltyAccountId() {
        return this.loyaltyAccountId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CalculateLoyaltyPointsRequest && this.equalTo((CalculateLoyaltyPointsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CalculateLoyaltyPointsRequest other) {
        return this.programId.equals(other.programId) && this.orderId.equals(other.orderId) && this.transactionAmountMoney.equals(other.transactionAmountMoney) && this.loyaltyAccountId.equals(other.loyaltyAccountId);
    }

    public int hashCode() {
        return Objects.hash(this.programId, this.orderId, this.transactionAmountMoney, this.loyaltyAccountId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ProgramIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ProgramIdStage,
    _FinalStage {
        private String programId;
        private Optional<String> loyaltyAccountId = Optional.empty();
        private Optional<Money> transactionAmountMoney = Optional.empty();
        private Optional<String> orderId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CalculateLoyaltyPointsRequest other) {
            this.programId(other.getProgramId());
            this.orderId(other.getOrderId());
            this.transactionAmountMoney(other.getTransactionAmountMoney());
            this.loyaltyAccountId(other.getLoyaltyAccountId());
            return this;
        }

        @Override
        @JsonSetter(value="program_id")
        public _FinalStage programId(@NotNull String programId) {
            this.programId = Objects.requireNonNull(programId, "programId must not be null");
            return this;
        }

        @Override
        public _FinalStage loyaltyAccountId(Nullable<String> loyaltyAccountId) {
            this.loyaltyAccountId = loyaltyAccountId.isNull() ? null : (loyaltyAccountId.isEmpty() ? Optional.empty() : Optional.of(loyaltyAccountId.get()));
            return this;
        }

        @Override
        public _FinalStage loyaltyAccountId(String loyaltyAccountId) {
            this.loyaltyAccountId = Optional.ofNullable(loyaltyAccountId);
            return this;
        }

        @Override
        @JsonSetter(value="loyalty_account_id", nulls=Nulls.SKIP)
        public _FinalStage loyaltyAccountId(Optional<String> loyaltyAccountId) {
            this.loyaltyAccountId = loyaltyAccountId;
            return this;
        }

        @Override
        public _FinalStage transactionAmountMoney(Money transactionAmountMoney) {
            this.transactionAmountMoney = Optional.ofNullable(transactionAmountMoney);
            return this;
        }

        @Override
        @JsonSetter(value="transaction_amount_money", nulls=Nulls.SKIP)
        public _FinalStage transactionAmountMoney(Optional<Money> transactionAmountMoney) {
            this.transactionAmountMoney = transactionAmountMoney;
            return this;
        }

        @Override
        public _FinalStage orderId(Nullable<String> orderId) {
            this.orderId = orderId.isNull() ? null : (orderId.isEmpty() ? Optional.empty() : Optional.of(orderId.get()));
            return this;
        }

        @Override
        public _FinalStage orderId(String orderId) {
            this.orderId = Optional.ofNullable(orderId);
            return this;
        }

        @Override
        @JsonSetter(value="order_id", nulls=Nulls.SKIP)
        public _FinalStage orderId(Optional<String> orderId) {
            this.orderId = orderId;
            return this;
        }

        @Override
        public CalculateLoyaltyPointsRequest build() {
            return new CalculateLoyaltyPointsRequest(this.programId, this.orderId, this.transactionAmountMoney, this.loyaltyAccountId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CalculateLoyaltyPointsRequest build();

        public _FinalStage orderId(Optional<String> var1);

        public _FinalStage orderId(String var1);

        public _FinalStage orderId(Nullable<String> var1);

        public _FinalStage transactionAmountMoney(Optional<Money> var1);

        public _FinalStage transactionAmountMoney(Money var1);

        public _FinalStage loyaltyAccountId(Optional<String> var1);

        public _FinalStage loyaltyAccountId(String var1);

        public _FinalStage loyaltyAccountId(Nullable<String> var1);
    }

    public static interface ProgramIdStage {
        public _FinalStage programId(@NotNull String var1);

        public Builder from(CalculateLoyaltyPointsRequest var1);
    }
}

