/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.loyalty.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.LoyaltyReward;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateLoyaltyRewardRequest {
    private final LoyaltyReward reward;
    private final String idempotencyKey;
    private final Map<String, Object> additionalProperties;

    private CreateLoyaltyRewardRequest(LoyaltyReward reward, String idempotencyKey, Map<String, Object> additionalProperties) {
        this.reward = reward;
        this.idempotencyKey = idempotencyKey;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="reward")
    public LoyaltyReward getReward() {
        return this.reward;
    }

    @JsonProperty(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateLoyaltyRewardRequest && this.equalTo((CreateLoyaltyRewardRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateLoyaltyRewardRequest other) {
        return this.reward.equals(other.reward) && this.idempotencyKey.equals(other.idempotencyKey);
    }

    public int hashCode() {
        return Objects.hash(this.reward, this.idempotencyKey);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static RewardStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements RewardStage,
    IdempotencyKeyStage,
    _FinalStage {
        private LoyaltyReward reward;
        private String idempotencyKey;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateLoyaltyRewardRequest other) {
            this.reward(other.getReward());
            this.idempotencyKey(other.getIdempotencyKey());
            return this;
        }

        @Override
        @JsonSetter(value="reward")
        public IdempotencyKeyStage reward(@NotNull LoyaltyReward reward) {
            this.reward = Objects.requireNonNull(reward, "reward must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="idempotency_key")
        public _FinalStage idempotencyKey(@NotNull String idempotencyKey) {
            this.idempotencyKey = Objects.requireNonNull(idempotencyKey, "idempotencyKey must not be null");
            return this;
        }

        @Override
        public CreateLoyaltyRewardRequest build() {
            return new CreateLoyaltyRewardRequest(this.reward, this.idempotencyKey, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateLoyaltyRewardRequest build();
    }

    public static interface IdempotencyKeyStage {
        public _FinalStage idempotencyKey(@NotNull String var1);
    }

    public static interface RewardStage {
        public IdempotencyKeyStage reward(@NotNull LoyaltyReward var1);

        public Builder from(CreateLoyaltyRewardRequest var1);
    }
}

