/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.loyalty.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class RedeemLoyaltyRewardRequest {
    private final String rewardId;
    private final String idempotencyKey;
    private final String locationId;
    private final Map<String, Object> additionalProperties;

    private RedeemLoyaltyRewardRequest(String rewardId, String idempotencyKey, String locationId, Map<String, Object> additionalProperties) {
        this.rewardId = rewardId;
        this.idempotencyKey = idempotencyKey;
        this.locationId = locationId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="reward_id")
    public String getRewardId() {
        return this.rewardId;
    }

    @JsonProperty(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonProperty(value="location_id")
    public String getLocationId() {
        return this.locationId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof RedeemLoyaltyRewardRequest && this.equalTo((RedeemLoyaltyRewardRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(RedeemLoyaltyRewardRequest other) {
        return this.rewardId.equals(other.rewardId) && this.idempotencyKey.equals(other.idempotencyKey) && this.locationId.equals(other.locationId);
    }

    public int hashCode() {
        return Objects.hash(this.rewardId, this.idempotencyKey, this.locationId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static RewardIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements RewardIdStage,
    IdempotencyKeyStage,
    LocationIdStage,
    _FinalStage {
        private String rewardId;
        private String idempotencyKey;
        private String locationId;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(RedeemLoyaltyRewardRequest other) {
            this.rewardId(other.getRewardId());
            this.idempotencyKey(other.getIdempotencyKey());
            this.locationId(other.getLocationId());
            return this;
        }

        @Override
        @JsonSetter(value="reward_id")
        public IdempotencyKeyStage rewardId(@NotNull String rewardId) {
            this.rewardId = Objects.requireNonNull(rewardId, "rewardId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="idempotency_key")
        public LocationIdStage idempotencyKey(@NotNull String idempotencyKey) {
            this.idempotencyKey = Objects.requireNonNull(idempotencyKey, "idempotencyKey must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="location_id")
        public _FinalStage locationId(@NotNull String locationId) {
            this.locationId = Objects.requireNonNull(locationId, "locationId must not be null");
            return this;
        }

        @Override
        public RedeemLoyaltyRewardRequest build() {
            return new RedeemLoyaltyRewardRequest(this.rewardId, this.idempotencyKey, this.locationId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public RedeemLoyaltyRewardRequest build();
    }

    public static interface LocationIdStage {
        public _FinalStage locationId(@NotNull String var1);
    }

    public static interface IdempotencyKeyStage {
        public LocationIdStage idempotencyKey(@NotNull String var1);
    }

    public static interface RewardIdStage {
        public IdempotencyKeyStage rewardId(@NotNull String var1);

        public Builder from(RedeemLoyaltyRewardRequest var1);
    }
}

