/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.merchants;

import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.merchants.AsyncRawCustomAttributesClient;
import com.squareup.square.merchants.types.BulkDeleteMerchantCustomAttributesRequest;
import com.squareup.square.merchants.types.BulkUpsertMerchantCustomAttributesRequest;
import com.squareup.square.merchants.types.DeleteCustomAttributesRequest;
import com.squareup.square.merchants.types.GetCustomAttributesRequest;
import com.squareup.square.merchants.types.ListCustomAttributesRequest;
import com.squareup.square.merchants.types.UpsertMerchantCustomAttributeRequest;
import com.squareup.square.types.BulkDeleteMerchantCustomAttributesResponse;
import com.squareup.square.types.BulkUpsertMerchantCustomAttributesResponse;
import com.squareup.square.types.CustomAttribute;
import com.squareup.square.types.DeleteMerchantCustomAttributeResponse;
import com.squareup.square.types.RetrieveMerchantCustomAttributeResponse;
import com.squareup.square.types.UpsertMerchantCustomAttributeResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncCustomAttributesClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawCustomAttributesClient rawClient;

    public AsyncCustomAttributesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawCustomAttributesClient(clientOptions);
    }

    public AsyncRawCustomAttributesClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<BulkDeleteMerchantCustomAttributesResponse> batchDelete(BulkDeleteMerchantCustomAttributesRequest request) {
        return this.rawClient.batchDelete(request).thenApply(response -> (BulkDeleteMerchantCustomAttributesResponse)response.body());
    }

    public CompletableFuture<BulkDeleteMerchantCustomAttributesResponse> batchDelete(BulkDeleteMerchantCustomAttributesRequest request, RequestOptions requestOptions) {
        return this.rawClient.batchDelete(request, requestOptions).thenApply(response -> (BulkDeleteMerchantCustomAttributesResponse)response.body());
    }

    public CompletableFuture<BulkUpsertMerchantCustomAttributesResponse> batchUpsert(BulkUpsertMerchantCustomAttributesRequest request) {
        return this.rawClient.batchUpsert(request).thenApply(response -> (BulkUpsertMerchantCustomAttributesResponse)response.body());
    }

    public CompletableFuture<BulkUpsertMerchantCustomAttributesResponse> batchUpsert(BulkUpsertMerchantCustomAttributesRequest request, RequestOptions requestOptions) {
        return this.rawClient.batchUpsert(request, requestOptions).thenApply(response -> (BulkUpsertMerchantCustomAttributesResponse)response.body());
    }

    public CompletableFuture<SyncPagingIterable<CustomAttribute>> list(ListCustomAttributesRequest request) {
        return this.rawClient.list(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<CustomAttribute>> list(ListCustomAttributesRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<RetrieveMerchantCustomAttributeResponse> get(GetCustomAttributesRequest request) {
        return this.rawClient.get(request).thenApply(response -> (RetrieveMerchantCustomAttributeResponse)response.body());
    }

    public CompletableFuture<RetrieveMerchantCustomAttributeResponse> get(GetCustomAttributesRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (RetrieveMerchantCustomAttributeResponse)response.body());
    }

    public CompletableFuture<UpsertMerchantCustomAttributeResponse> upsert(UpsertMerchantCustomAttributeRequest request) {
        return this.rawClient.upsert(request).thenApply(response -> (UpsertMerchantCustomAttributeResponse)response.body());
    }

    public CompletableFuture<UpsertMerchantCustomAttributeResponse> upsert(UpsertMerchantCustomAttributeRequest request, RequestOptions requestOptions) {
        return this.rawClient.upsert(request, requestOptions).thenApply(response -> (UpsertMerchantCustomAttributeResponse)response.body());
    }

    public CompletableFuture<DeleteMerchantCustomAttributeResponse> delete(DeleteCustomAttributesRequest request) {
        return this.rawClient.delete(request).thenApply(response -> (DeleteMerchantCustomAttributeResponse)response.body());
    }

    public CompletableFuture<DeleteMerchantCustomAttributeResponse> delete(DeleteCustomAttributesRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(request, requestOptions).thenApply(response -> (DeleteMerchantCustomAttributeResponse)response.body());
    }
}

