/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.merchants;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.MediaTypes;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.core.QueryStringMapper;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SquareApiException;
import com.squareup.square.core.SquareClientHttpResponse;
import com.squareup.square.core.SquareException;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.merchants.types.BulkDeleteMerchantCustomAttributesRequest;
import com.squareup.square.merchants.types.BulkUpsertMerchantCustomAttributesRequest;
import com.squareup.square.merchants.types.DeleteCustomAttributesRequest;
import com.squareup.square.merchants.types.GetCustomAttributesRequest;
import com.squareup.square.merchants.types.ListCustomAttributesRequest;
import com.squareup.square.merchants.types.UpsertMerchantCustomAttributeRequest;
import com.squareup.square.types.BulkDeleteMerchantCustomAttributesResponse;
import com.squareup.square.types.BulkUpsertMerchantCustomAttributesResponse;
import com.squareup.square.types.CustomAttribute;
import com.squareup.square.types.DeleteMerchantCustomAttributeResponse;
import com.squareup.square.types.ListMerchantCustomAttributesResponse;
import com.squareup.square.types.RetrieveMerchantCustomAttributeResponse;
import com.squareup.square.types.UpsertMerchantCustomAttributeResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawCustomAttributesClient {
    protected final ClientOptions clientOptions;

    public RawCustomAttributesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public SquareClientHttpResponse<BulkDeleteMerchantCustomAttributesResponse> batchDelete(BulkDeleteMerchantCustomAttributesRequest request) {
        return this.batchDelete(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<BulkDeleteMerchantCustomAttributesResponse> batchDelete(BulkDeleteMerchantCustomAttributesRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/merchants/custom-attributes/bulk-delete").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<BulkDeleteMerchantCustomAttributesResponse> squareClientHttpResponse = new SquareClientHttpResponse<BulkDeleteMerchantCustomAttributesResponse>((BulkDeleteMerchantCustomAttributesResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), BulkDeleteMerchantCustomAttributesResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<BulkUpsertMerchantCustomAttributesResponse> batchUpsert(BulkUpsertMerchantCustomAttributesRequest request) {
        return this.batchUpsert(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<BulkUpsertMerchantCustomAttributesResponse> batchUpsert(BulkUpsertMerchantCustomAttributesRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/merchants/custom-attributes/bulk-upsert").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<BulkUpsertMerchantCustomAttributesResponse> squareClientHttpResponse = new SquareClientHttpResponse<BulkUpsertMerchantCustomAttributesResponse>((BulkUpsertMerchantCustomAttributesResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), BulkUpsertMerchantCustomAttributesResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<SyncPagingIterable<CustomAttribute>> list(ListCustomAttributesRequest request) {
        return this.list(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<SyncPagingIterable<CustomAttribute>> list(ListCustomAttributesRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/merchants").addPathSegment(request.getMerchantId()).addPathSegments("custom-attributes");
        if (request.getVisibilityFilter().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "visibility_filter", request.getVisibilityFilter().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getCursor().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "cursor", request.getCursor().get(), false);
        }
        if (request.getWithDefinitions().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "with_definitions", request.getWithDefinitions().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                ListMerchantCustomAttributesResponse parsedResponse = (ListMerchantCustomAttributesResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListMerchantCustomAttributesResponse.class);
                Optional<String> startingAfter = parsedResponse.getCursor();
                ListCustomAttributesRequest nextRequest = ListCustomAttributesRequest.builder().from(request).cursor(startingAfter).build();
                List result = parsedResponse.getCustomAttributes().orElse(Collections.emptyList());
                SquareClientHttpResponse<SyncPagingIterable<CustomAttribute>> squareClientHttpResponse = new SquareClientHttpResponse<SyncPagingIterable<CustomAttribute>>(new SyncPagingIterable(startingAfter.isPresent(), result, () -> this.list(nextRequest, requestOptions).body()), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<RetrieveMerchantCustomAttributeResponse> get(GetCustomAttributesRequest request) {
        return this.get(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<RetrieveMerchantCustomAttributeResponse> get(GetCustomAttributesRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/merchants").addPathSegment(request.getMerchantId()).addPathSegments("custom-attributes").addPathSegment(request.getKey());
        if (request.getWithDefinition().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "with_definition", request.getWithDefinition().get(), false);
        }
        if (request.getVersion().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "version", request.getVersion().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<RetrieveMerchantCustomAttributeResponse> squareClientHttpResponse = new SquareClientHttpResponse<RetrieveMerchantCustomAttributeResponse>((RetrieveMerchantCustomAttributeResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), RetrieveMerchantCustomAttributeResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<UpsertMerchantCustomAttributeResponse> upsert(UpsertMerchantCustomAttributeRequest request) {
        return this.upsert(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<UpsertMerchantCustomAttributeResponse> upsert(UpsertMerchantCustomAttributeRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/merchants").addPathSegment(request.getMerchantId()).addPathSegments("custom-attributes").addPathSegment(request.getKey()).build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<UpsertMerchantCustomAttributeResponse> squareClientHttpResponse = new SquareClientHttpResponse<UpsertMerchantCustomAttributeResponse>((UpsertMerchantCustomAttributeResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), UpsertMerchantCustomAttributeResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<DeleteMerchantCustomAttributeResponse> delete(DeleteCustomAttributesRequest request) {
        return this.delete(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<DeleteMerchantCustomAttributeResponse> delete(DeleteCustomAttributesRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/merchants").addPathSegment(request.getMerchantId()).addPathSegments("custom-attributes").addPathSegment(request.getKey()).build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("DELETE", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<DeleteMerchantCustomAttributeResponse> squareClientHttpResponse = new SquareClientHttpResponse<DeleteMerchantCustomAttributeResponse>((DeleteMerchantCustomAttributeResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), DeleteMerchantCustomAttributeResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }
}

