/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.merchants.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GetCustomAttributeDefinitionsRequest {
    private final String key;
    private final Optional<Integer> version;
    private final Map<String, Object> additionalProperties;

    private GetCustomAttributeDefinitionsRequest(String key, Optional<Integer> version, Map<String, Object> additionalProperties) {
        this.key = key;
        this.version = version;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="key")
    public String getKey() {
        return this.key;
    }

    @JsonIgnore
    public Optional<Integer> getVersion() {
        if (this.version == null) {
            return Optional.empty();
        }
        return this.version;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="version")
    private Optional<Integer> _getVersion() {
        return this.version;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetCustomAttributeDefinitionsRequest && this.equalTo((GetCustomAttributeDefinitionsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetCustomAttributeDefinitionsRequest other) {
        return this.key.equals(other.key) && this.version.equals(other.version);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.version);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static KeyStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements KeyStage,
    _FinalStage {
        private String key;
        private Optional<Integer> version = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(GetCustomAttributeDefinitionsRequest other) {
            this.key(other.getKey());
            this.version(other.getVersion());
            return this;
        }

        @Override
        @JsonSetter(value="key")
        public _FinalStage key(@NotNull String key) {
            this.key = Objects.requireNonNull(key, "key must not be null");
            return this;
        }

        @Override
        public _FinalStage version(Nullable<Integer> version) {
            this.version = version.isNull() ? null : (version.isEmpty() ? Optional.empty() : Optional.of(version.get()));
            return this;
        }

        @Override
        public _FinalStage version(Integer version) {
            this.version = Optional.ofNullable(version);
            return this;
        }

        @Override
        @JsonSetter(value="version", nulls=Nulls.SKIP)
        public _FinalStage version(Optional<Integer> version) {
            this.version = version;
            return this;
        }

        @Override
        public GetCustomAttributeDefinitionsRequest build() {
            return new GetCustomAttributeDefinitionsRequest(this.key, this.version, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public GetCustomAttributeDefinitionsRequest build();

        public _FinalStage version(Optional<Integer> var1);

        public _FinalStage version(Integer var1);

        public _FinalStage version(Nullable<Integer> var1);
    }

    public static interface KeyStage {
        public _FinalStage key(@NotNull String var1);

        public Builder from(GetCustomAttributeDefinitionsRequest var1);
    }
}

