/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.merchants.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CustomAttributeDefinition;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateMerchantCustomAttributeDefinitionRequest {
    private final String key;
    private final CustomAttributeDefinition customAttributeDefinition;
    private final Optional<String> idempotencyKey;
    private final Map<String, Object> additionalProperties;

    private UpdateMerchantCustomAttributeDefinitionRequest(String key, CustomAttributeDefinition customAttributeDefinition, Optional<String> idempotencyKey, Map<String, Object> additionalProperties) {
        this.key = key;
        this.customAttributeDefinition = customAttributeDefinition;
        this.idempotencyKey = idempotencyKey;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="key")
    public String getKey() {
        return this.key;
    }

    @JsonProperty(value="custom_attribute_definition")
    public CustomAttributeDefinition getCustomAttributeDefinition() {
        return this.customAttributeDefinition;
    }

    @JsonIgnore
    public Optional<String> getIdempotencyKey() {
        if (this.idempotencyKey == null) {
            return Optional.empty();
        }
        return this.idempotencyKey;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="idempotency_key")
    private Optional<String> _getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateMerchantCustomAttributeDefinitionRequest && this.equalTo((UpdateMerchantCustomAttributeDefinitionRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateMerchantCustomAttributeDefinitionRequest other) {
        return this.key.equals(other.key) && this.customAttributeDefinition.equals(other.customAttributeDefinition) && this.idempotencyKey.equals(other.idempotencyKey);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.customAttributeDefinition, this.idempotencyKey);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static KeyStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements KeyStage,
    CustomAttributeDefinitionStage,
    _FinalStage {
        private String key;
        private CustomAttributeDefinition customAttributeDefinition;
        private Optional<String> idempotencyKey = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdateMerchantCustomAttributeDefinitionRequest other) {
            this.key(other.getKey());
            this.customAttributeDefinition(other.getCustomAttributeDefinition());
            this.idempotencyKey(other.getIdempotencyKey());
            return this;
        }

        @Override
        @JsonSetter(value="key")
        public CustomAttributeDefinitionStage key(@NotNull String key) {
            this.key = Objects.requireNonNull(key, "key must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="custom_attribute_definition")
        public _FinalStage customAttributeDefinition(@NotNull CustomAttributeDefinition customAttributeDefinition) {
            this.customAttributeDefinition = Objects.requireNonNull(customAttributeDefinition, "customAttributeDefinition must not be null");
            return this;
        }

        @Override
        public _FinalStage idempotencyKey(Nullable<String> idempotencyKey) {
            this.idempotencyKey = idempotencyKey.isNull() ? null : (idempotencyKey.isEmpty() ? Optional.empty() : Optional.of(idempotencyKey.get()));
            return this;
        }

        @Override
        public _FinalStage idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = Optional.ofNullable(idempotencyKey);
            return this;
        }

        @Override
        @JsonSetter(value="idempotency_key", nulls=Nulls.SKIP)
        public _FinalStage idempotencyKey(Optional<String> idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        @Override
        public UpdateMerchantCustomAttributeDefinitionRequest build() {
            return new UpdateMerchantCustomAttributeDefinitionRequest(this.key, this.customAttributeDefinition, this.idempotencyKey, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdateMerchantCustomAttributeDefinitionRequest build();

        public _FinalStage idempotencyKey(Optional<String> var1);

        public _FinalStage idempotencyKey(String var1);

        public _FinalStage idempotencyKey(Nullable<String> var1);
    }

    public static interface CustomAttributeDefinitionStage {
        public _FinalStage customAttributeDefinition(@NotNull CustomAttributeDefinition var1);
    }

    public static interface KeyStage {
        public CustomAttributeDefinitionStage key(@NotNull String var1);

        public Builder from(UpdateMerchantCustomAttributeDefinitionRequest var1);
    }
}

