/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.orders.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GetCustomAttributesRequest {
    private final String orderId;
    private final String customAttributeKey;
    private final Optional<Integer> version;
    private final Optional<Boolean> withDefinition;
    private final Map<String, Object> additionalProperties;

    private GetCustomAttributesRequest(String orderId, String customAttributeKey, Optional<Integer> version, Optional<Boolean> withDefinition, Map<String, Object> additionalProperties) {
        this.orderId = orderId;
        this.customAttributeKey = customAttributeKey;
        this.version = version;
        this.withDefinition = withDefinition;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="order_id")
    public String getOrderId() {
        return this.orderId;
    }

    @JsonProperty(value="custom_attribute_key")
    public String getCustomAttributeKey() {
        return this.customAttributeKey;
    }

    @JsonIgnore
    public Optional<Integer> getVersion() {
        if (this.version == null) {
            return Optional.empty();
        }
        return this.version;
    }

    @JsonIgnore
    public Optional<Boolean> getWithDefinition() {
        if (this.withDefinition == null) {
            return Optional.empty();
        }
        return this.withDefinition;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="version")
    private Optional<Integer> _getVersion() {
        return this.version;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="with_definition")
    private Optional<Boolean> _getWithDefinition() {
        return this.withDefinition;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetCustomAttributesRequest && this.equalTo((GetCustomAttributesRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetCustomAttributesRequest other) {
        return this.orderId.equals(other.orderId) && this.customAttributeKey.equals(other.customAttributeKey) && this.version.equals(other.version) && this.withDefinition.equals(other.withDefinition);
    }

    public int hashCode() {
        return Objects.hash(this.orderId, this.customAttributeKey, this.version, this.withDefinition);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static OrderIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements OrderIdStage,
    CustomAttributeKeyStage,
    _FinalStage {
        private String orderId;
        private String customAttributeKey;
        private Optional<Boolean> withDefinition = Optional.empty();
        private Optional<Integer> version = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(GetCustomAttributesRequest other) {
            this.orderId(other.getOrderId());
            this.customAttributeKey(other.getCustomAttributeKey());
            this.version(other.getVersion());
            this.withDefinition(other.getWithDefinition());
            return this;
        }

        @Override
        @JsonSetter(value="order_id")
        public CustomAttributeKeyStage orderId(@NotNull String orderId) {
            this.orderId = Objects.requireNonNull(orderId, "orderId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="custom_attribute_key")
        public _FinalStage customAttributeKey(@NotNull String customAttributeKey) {
            this.customAttributeKey = Objects.requireNonNull(customAttributeKey, "customAttributeKey must not be null");
            return this;
        }

        @Override
        public _FinalStage withDefinition(Nullable<Boolean> withDefinition) {
            this.withDefinition = withDefinition.isNull() ? null : (withDefinition.isEmpty() ? Optional.empty() : Optional.of(withDefinition.get()));
            return this;
        }

        @Override
        public _FinalStage withDefinition(Boolean withDefinition) {
            this.withDefinition = Optional.ofNullable(withDefinition);
            return this;
        }

        @Override
        @JsonSetter(value="with_definition", nulls=Nulls.SKIP)
        public _FinalStage withDefinition(Optional<Boolean> withDefinition) {
            this.withDefinition = withDefinition;
            return this;
        }

        @Override
        public _FinalStage version(Nullable<Integer> version) {
            this.version = version.isNull() ? null : (version.isEmpty() ? Optional.empty() : Optional.of(version.get()));
            return this;
        }

        @Override
        public _FinalStage version(Integer version) {
            this.version = Optional.ofNullable(version);
            return this;
        }

        @Override
        @JsonSetter(value="version", nulls=Nulls.SKIP)
        public _FinalStage version(Optional<Integer> version) {
            this.version = version;
            return this;
        }

        @Override
        public GetCustomAttributesRequest build() {
            return new GetCustomAttributesRequest(this.orderId, this.customAttributeKey, this.version, this.withDefinition, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public GetCustomAttributesRequest build();

        public _FinalStage version(Optional<Integer> var1);

        public _FinalStage version(Integer var1);

        public _FinalStage version(Nullable<Integer> var1);

        public _FinalStage withDefinition(Optional<Boolean> var1);

        public _FinalStage withDefinition(Boolean var1);

        public _FinalStage withDefinition(Nullable<Boolean> var1);
    }

    public static interface CustomAttributeKeyStage {
        public _FinalStage customAttributeKey(@NotNull String var1);
    }

    public static interface OrderIdStage {
        public CustomAttributeKeyStage orderId(@NotNull String var1);

        public Builder from(GetCustomAttributesRequest var1);
    }
}

