/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.teammembers;

import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.teammembers.AsyncRawWageSettingClient;
import com.squareup.square.teammembers.types.GetWageSettingRequest;
import com.squareup.square.teammembers.types.UpdateWageSettingRequest;
import com.squareup.square.types.GetWageSettingResponse;
import com.squareup.square.types.UpdateWageSettingResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncWageSettingClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawWageSettingClient rawClient;

    public AsyncWageSettingClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawWageSettingClient(clientOptions);
    }

    public AsyncRawWageSettingClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<GetWageSettingResponse> get(GetWageSettingRequest request) {
        return this.rawClient.get(request).thenApply(response -> (GetWageSettingResponse)response.body());
    }

    public CompletableFuture<GetWageSettingResponse> get(GetWageSettingRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (GetWageSettingResponse)response.body());
    }

    public CompletableFuture<UpdateWageSettingResponse> update(UpdateWageSettingRequest request) {
        return this.rawClient.update(request).thenApply(response -> (UpdateWageSettingResponse)response.body());
    }

    public CompletableFuture<UpdateWageSettingResponse> update(UpdateWageSettingRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).thenApply(response -> (UpdateWageSettingResponse)response.body());
    }
}

