/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.terminal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.MediaTypes;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SquareApiException;
import com.squareup.square.core.SquareClientHttpResponse;
import com.squareup.square.core.SquareException;
import com.squareup.square.terminal.types.CancelCheckoutsRequest;
import com.squareup.square.terminal.types.CreateTerminalCheckoutRequest;
import com.squareup.square.terminal.types.GetCheckoutsRequest;
import com.squareup.square.terminal.types.SearchTerminalCheckoutsRequest;
import com.squareup.square.types.CancelTerminalCheckoutResponse;
import com.squareup.square.types.CreateTerminalCheckoutResponse;
import com.squareup.square.types.GetTerminalCheckoutResponse;
import com.squareup.square.types.SearchTerminalCheckoutsResponse;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawCheckoutsClient {
    protected final ClientOptions clientOptions;

    public RawCheckoutsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public SquareClientHttpResponse<CreateTerminalCheckoutResponse> create(CreateTerminalCheckoutRequest request) {
        return this.create(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<CreateTerminalCheckoutResponse> create(CreateTerminalCheckoutRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/terminals/checkouts").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<CreateTerminalCheckoutResponse> squareClientHttpResponse = new SquareClientHttpResponse<CreateTerminalCheckoutResponse>((CreateTerminalCheckoutResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CreateTerminalCheckoutResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<SearchTerminalCheckoutsResponse> search() {
        return this.search(SearchTerminalCheckoutsRequest.builder().build());
    }

    public SquareClientHttpResponse<SearchTerminalCheckoutsResponse> search(SearchTerminalCheckoutsRequest request) {
        return this.search(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<SearchTerminalCheckoutsResponse> search(SearchTerminalCheckoutsRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/terminals/checkouts/search").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<SearchTerminalCheckoutsResponse> squareClientHttpResponse = new SquareClientHttpResponse<SearchTerminalCheckoutsResponse>((SearchTerminalCheckoutsResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), SearchTerminalCheckoutsResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<GetTerminalCheckoutResponse> get(GetCheckoutsRequest request) {
        return this.get(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<GetTerminalCheckoutResponse> get(GetCheckoutsRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/terminals/checkouts").addPathSegment(request.getCheckoutId()).build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<GetTerminalCheckoutResponse> squareClientHttpResponse = new SquareClientHttpResponse<GetTerminalCheckoutResponse>((GetTerminalCheckoutResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), GetTerminalCheckoutResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<CancelTerminalCheckoutResponse> cancel(CancelCheckoutsRequest request) {
        return this.cancel(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<CancelTerminalCheckoutResponse> cancel(CancelCheckoutsRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/terminals/checkouts").addPathSegment(request.getCheckoutId()).addPathSegments("cancel").build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("POST", RequestBody.create((String)"", null)).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<CancelTerminalCheckoutResponse> squareClientHttpResponse = new SquareClientHttpResponse<CancelTerminalCheckoutResponse>((CancelTerminalCheckoutResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CancelTerminalCheckoutResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }
}

