/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.terminal.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.TerminalRefund;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateTerminalRefundRequest {
    private final String idempotencyKey;
    private final Optional<TerminalRefund> refund;
    private final Map<String, Object> additionalProperties;

    private CreateTerminalRefundRequest(String idempotencyKey, Optional<TerminalRefund> refund, Map<String, Object> additionalProperties) {
        this.idempotencyKey = idempotencyKey;
        this.refund = refund;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonProperty(value="refund")
    public Optional<TerminalRefund> getRefund() {
        return this.refund;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateTerminalRefundRequest && this.equalTo((CreateTerminalRefundRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateTerminalRefundRequest other) {
        return this.idempotencyKey.equals(other.idempotencyKey) && this.refund.equals(other.refund);
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.refund);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdempotencyKeyStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdempotencyKeyStage,
    _FinalStage {
        private String idempotencyKey;
        private Optional<TerminalRefund> refund = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateTerminalRefundRequest other) {
            this.idempotencyKey(other.getIdempotencyKey());
            this.refund(other.getRefund());
            return this;
        }

        @Override
        @JsonSetter(value="idempotency_key")
        public _FinalStage idempotencyKey(@NotNull String idempotencyKey) {
            this.idempotencyKey = Objects.requireNonNull(idempotencyKey, "idempotencyKey must not be null");
            return this;
        }

        @Override
        public _FinalStage refund(TerminalRefund refund) {
            this.refund = Optional.ofNullable(refund);
            return this;
        }

        @Override
        @JsonSetter(value="refund", nulls=Nulls.SKIP)
        public _FinalStage refund(Optional<TerminalRefund> refund) {
            this.refund = refund;
            return this;
        }

        @Override
        public CreateTerminalRefundRequest build() {
            return new CreateTerminalRefundRequest(this.idempotencyKey, this.refund, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateTerminalRefundRequest build();

        public _FinalStage refund(Optional<TerminalRefund> var1);

        public _FinalStage refund(TerminalRefund var1);
    }

    public static interface IdempotencyKeyStage {
        public _FinalStage idempotencyKey(@NotNull String var1);

        public Builder from(CreateTerminalRefundRequest var1);
    }
}

