/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import com.squareup.square.types.LoyaltyEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class AccumulateLoyaltyPointsResponse {
    private final Optional<List<Error>> errors;
    private final Optional<LoyaltyEvent> event;
    private final Optional<List<LoyaltyEvent>> events;
    private final Map<String, Object> additionalProperties;

    private AccumulateLoyaltyPointsResponse(Optional<List<Error>> errors, Optional<LoyaltyEvent> event, Optional<List<LoyaltyEvent>> events, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.event = event;
        this.events = events;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="event")
    public Optional<LoyaltyEvent> getEvent() {
        return this.event;
    }

    @JsonProperty(value="events")
    public Optional<List<LoyaltyEvent>> getEvents() {
        return this.events;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AccumulateLoyaltyPointsResponse && this.equalTo((AccumulateLoyaltyPointsResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AccumulateLoyaltyPointsResponse other) {
        return this.errors.equals(other.errors) && this.event.equals(other.event) && this.events.equals(other.events);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.event, this.events);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<LoyaltyEvent> event = Optional.empty();
        private Optional<List<LoyaltyEvent>> events = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(AccumulateLoyaltyPointsResponse other) {
            this.errors(other.getErrors());
            this.event(other.getEvent());
            this.events(other.getEvents());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="event", nulls=Nulls.SKIP)
        public Builder event(Optional<LoyaltyEvent> event) {
            this.event = event;
            return this;
        }

        public Builder event(LoyaltyEvent event) {
            this.event = Optional.ofNullable(event);
            return this;
        }

        @JsonSetter(value="events", nulls=Nulls.SKIP)
        public Builder events(Optional<List<LoyaltyEvent>> events) {
            this.events = events;
            return this;
        }

        public Builder events(List<LoyaltyEvent> events) {
            this.events = Optional.ofNullable(events);
            return this;
        }

        public AccumulateLoyaltyPointsResponse build() {
            return new AccumulateLoyaltyPointsResponse(this.errors, this.event, this.events, this.additionalProperties);
        }
    }
}

