/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class AchDetails {
    private final Optional<String> routingNumber;
    private final Optional<String> accountNumberSuffix;
    private final Optional<String> accountType;
    private final Map<String, Object> additionalProperties;

    private AchDetails(Optional<String> routingNumber, Optional<String> accountNumberSuffix, Optional<String> accountType, Map<String, Object> additionalProperties) {
        this.routingNumber = routingNumber;
        this.accountNumberSuffix = accountNumberSuffix;
        this.accountType = accountType;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getRoutingNumber() {
        if (this.routingNumber == null) {
            return Optional.empty();
        }
        return this.routingNumber;
    }

    @JsonIgnore
    public Optional<String> getAccountNumberSuffix() {
        if (this.accountNumberSuffix == null) {
            return Optional.empty();
        }
        return this.accountNumberSuffix;
    }

    @JsonIgnore
    public Optional<String> getAccountType() {
        if (this.accountType == null) {
            return Optional.empty();
        }
        return this.accountType;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="routing_number")
    private Optional<String> _getRoutingNumber() {
        return this.routingNumber;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="account_number_suffix")
    private Optional<String> _getAccountNumberSuffix() {
        return this.accountNumberSuffix;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="account_type")
    private Optional<String> _getAccountType() {
        return this.accountType;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AchDetails && this.equalTo((AchDetails)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AchDetails other) {
        return this.routingNumber.equals(other.routingNumber) && this.accountNumberSuffix.equals(other.accountNumberSuffix) && this.accountType.equals(other.accountType);
    }

    public int hashCode() {
        return Objects.hash(this.routingNumber, this.accountNumberSuffix, this.accountType);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> routingNumber = Optional.empty();
        private Optional<String> accountNumberSuffix = Optional.empty();
        private Optional<String> accountType = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(AchDetails other) {
            this.routingNumber(other.getRoutingNumber());
            this.accountNumberSuffix(other.getAccountNumberSuffix());
            this.accountType(other.getAccountType());
            return this;
        }

        @JsonSetter(value="routing_number", nulls=Nulls.SKIP)
        public Builder routingNumber(Optional<String> routingNumber) {
            this.routingNumber = routingNumber;
            return this;
        }

        public Builder routingNumber(String routingNumber) {
            this.routingNumber = Optional.ofNullable(routingNumber);
            return this;
        }

        public Builder routingNumber(Nullable<String> routingNumber) {
            this.routingNumber = routingNumber.isNull() ? null : (routingNumber.isEmpty() ? Optional.empty() : Optional.of(routingNumber.get()));
            return this;
        }

        @JsonSetter(value="account_number_suffix", nulls=Nulls.SKIP)
        public Builder accountNumberSuffix(Optional<String> accountNumberSuffix) {
            this.accountNumberSuffix = accountNumberSuffix;
            return this;
        }

        public Builder accountNumberSuffix(String accountNumberSuffix) {
            this.accountNumberSuffix = Optional.ofNullable(accountNumberSuffix);
            return this;
        }

        public Builder accountNumberSuffix(Nullable<String> accountNumberSuffix) {
            this.accountNumberSuffix = accountNumberSuffix.isNull() ? null : (accountNumberSuffix.isEmpty() ? Optional.empty() : Optional.of(accountNumberSuffix.get()));
            return this;
        }

        @JsonSetter(value="account_type", nulls=Nulls.SKIP)
        public Builder accountType(Optional<String> accountType) {
            this.accountType = accountType;
            return this;
        }

        public Builder accountType(String accountType) {
            this.accountType = Optional.ofNullable(accountType);
            return this;
        }

        public Builder accountType(Nullable<String> accountType) {
            this.accountType = accountType.isNull() ? null : (accountType.isEmpty() ? Optional.empty() : Optional.of(accountType.get()));
            return this;
        }

        public AchDetails build() {
            return new AchDetails(this.routingNumber, this.accountNumberSuffix, this.accountType, this.additionalProperties);
        }
    }
}

