/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class AppointmentSegment {
    private final Optional<Integer> durationMinutes;
    private final Optional<String> serviceVariationId;
    private final String teamMemberId;
    private final Optional<Long> serviceVariationVersion;
    private final Optional<Integer> intermissionMinutes;
    private final Optional<Boolean> anyTeamMember;
    private final Optional<List<String>> resourceIds;
    private final Map<String, Object> additionalProperties;

    private AppointmentSegment(Optional<Integer> durationMinutes, Optional<String> serviceVariationId, String teamMemberId, Optional<Long> serviceVariationVersion, Optional<Integer> intermissionMinutes, Optional<Boolean> anyTeamMember, Optional<List<String>> resourceIds, Map<String, Object> additionalProperties) {
        this.durationMinutes = durationMinutes;
        this.serviceVariationId = serviceVariationId;
        this.teamMemberId = teamMemberId;
        this.serviceVariationVersion = serviceVariationVersion;
        this.intermissionMinutes = intermissionMinutes;
        this.anyTeamMember = anyTeamMember;
        this.resourceIds = resourceIds;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<Integer> getDurationMinutes() {
        if (this.durationMinutes == null) {
            return Optional.empty();
        }
        return this.durationMinutes;
    }

    @JsonIgnore
    public Optional<String> getServiceVariationId() {
        if (this.serviceVariationId == null) {
            return Optional.empty();
        }
        return this.serviceVariationId;
    }

    @JsonProperty(value="team_member_id")
    public String getTeamMemberId() {
        return this.teamMemberId;
    }

    @JsonIgnore
    public Optional<Long> getServiceVariationVersion() {
        if (this.serviceVariationVersion == null) {
            return Optional.empty();
        }
        return this.serviceVariationVersion;
    }

    @JsonProperty(value="intermission_minutes")
    public Optional<Integer> getIntermissionMinutes() {
        return this.intermissionMinutes;
    }

    @JsonProperty(value="any_team_member")
    public Optional<Boolean> getAnyTeamMember() {
        return this.anyTeamMember;
    }

    @JsonProperty(value="resource_ids")
    public Optional<List<String>> getResourceIds() {
        return this.resourceIds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="duration_minutes")
    private Optional<Integer> _getDurationMinutes() {
        return this.durationMinutes;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="service_variation_id")
    private Optional<String> _getServiceVariationId() {
        return this.serviceVariationId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="service_variation_version")
    private Optional<Long> _getServiceVariationVersion() {
        return this.serviceVariationVersion;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AppointmentSegment && this.equalTo((AppointmentSegment)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AppointmentSegment other) {
        return this.durationMinutes.equals(other.durationMinutes) && this.serviceVariationId.equals(other.serviceVariationId) && this.teamMemberId.equals(other.teamMemberId) && this.serviceVariationVersion.equals(other.serviceVariationVersion) && this.intermissionMinutes.equals(other.intermissionMinutes) && this.anyTeamMember.equals(other.anyTeamMember) && this.resourceIds.equals(other.resourceIds);
    }

    public int hashCode() {
        return Objects.hash(this.durationMinutes, this.serviceVariationId, this.teamMemberId, this.serviceVariationVersion, this.intermissionMinutes, this.anyTeamMember, this.resourceIds);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TeamMemberIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TeamMemberIdStage,
    _FinalStage {
        private String teamMemberId;
        private Optional<List<String>> resourceIds = Optional.empty();
        private Optional<Boolean> anyTeamMember = Optional.empty();
        private Optional<Integer> intermissionMinutes = Optional.empty();
        private Optional<Long> serviceVariationVersion = Optional.empty();
        private Optional<String> serviceVariationId = Optional.empty();
        private Optional<Integer> durationMinutes = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(AppointmentSegment other) {
            this.durationMinutes(other.getDurationMinutes());
            this.serviceVariationId(other.getServiceVariationId());
            this.teamMemberId(other.getTeamMemberId());
            this.serviceVariationVersion(other.getServiceVariationVersion());
            this.intermissionMinutes(other.getIntermissionMinutes());
            this.anyTeamMember(other.getAnyTeamMember());
            this.resourceIds(other.getResourceIds());
            return this;
        }

        @Override
        @JsonSetter(value="team_member_id")
        public _FinalStage teamMemberId(@NotNull String teamMemberId) {
            this.teamMemberId = Objects.requireNonNull(teamMemberId, "teamMemberId must not be null");
            return this;
        }

        @Override
        public _FinalStage resourceIds(List<String> resourceIds) {
            this.resourceIds = Optional.ofNullable(resourceIds);
            return this;
        }

        @Override
        @JsonSetter(value="resource_ids", nulls=Nulls.SKIP)
        public _FinalStage resourceIds(Optional<List<String>> resourceIds) {
            this.resourceIds = resourceIds;
            return this;
        }

        @Override
        public _FinalStage anyTeamMember(Boolean anyTeamMember) {
            this.anyTeamMember = Optional.ofNullable(anyTeamMember);
            return this;
        }

        @Override
        @JsonSetter(value="any_team_member", nulls=Nulls.SKIP)
        public _FinalStage anyTeamMember(Optional<Boolean> anyTeamMember) {
            this.anyTeamMember = anyTeamMember;
            return this;
        }

        @Override
        public _FinalStage intermissionMinutes(Integer intermissionMinutes) {
            this.intermissionMinutes = Optional.ofNullable(intermissionMinutes);
            return this;
        }

        @Override
        @JsonSetter(value="intermission_minutes", nulls=Nulls.SKIP)
        public _FinalStage intermissionMinutes(Optional<Integer> intermissionMinutes) {
            this.intermissionMinutes = intermissionMinutes;
            return this;
        }

        @Override
        public _FinalStage serviceVariationVersion(Nullable<Long> serviceVariationVersion) {
            this.serviceVariationVersion = serviceVariationVersion.isNull() ? null : (serviceVariationVersion.isEmpty() ? Optional.empty() : Optional.of(serviceVariationVersion.get()));
            return this;
        }

        @Override
        public _FinalStage serviceVariationVersion(Long serviceVariationVersion) {
            this.serviceVariationVersion = Optional.ofNullable(serviceVariationVersion);
            return this;
        }

        @Override
        @JsonSetter(value="service_variation_version", nulls=Nulls.SKIP)
        public _FinalStage serviceVariationVersion(Optional<Long> serviceVariationVersion) {
            this.serviceVariationVersion = serviceVariationVersion;
            return this;
        }

        @Override
        public _FinalStage serviceVariationId(Nullable<String> serviceVariationId) {
            this.serviceVariationId = serviceVariationId.isNull() ? null : (serviceVariationId.isEmpty() ? Optional.empty() : Optional.of(serviceVariationId.get()));
            return this;
        }

        @Override
        public _FinalStage serviceVariationId(String serviceVariationId) {
            this.serviceVariationId = Optional.ofNullable(serviceVariationId);
            return this;
        }

        @Override
        @JsonSetter(value="service_variation_id", nulls=Nulls.SKIP)
        public _FinalStage serviceVariationId(Optional<String> serviceVariationId) {
            this.serviceVariationId = serviceVariationId;
            return this;
        }

        @Override
        public _FinalStage durationMinutes(Nullable<Integer> durationMinutes) {
            this.durationMinutes = durationMinutes.isNull() ? null : (durationMinutes.isEmpty() ? Optional.empty() : Optional.of(durationMinutes.get()));
            return this;
        }

        @Override
        public _FinalStage durationMinutes(Integer durationMinutes) {
            this.durationMinutes = Optional.ofNullable(durationMinutes);
            return this;
        }

        @Override
        @JsonSetter(value="duration_minutes", nulls=Nulls.SKIP)
        public _FinalStage durationMinutes(Optional<Integer> durationMinutes) {
            this.durationMinutes = durationMinutes;
            return this;
        }

        @Override
        public AppointmentSegment build() {
            return new AppointmentSegment(this.durationMinutes, this.serviceVariationId, this.teamMemberId, this.serviceVariationVersion, this.intermissionMinutes, this.anyTeamMember, this.resourceIds, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public AppointmentSegment build();

        public _FinalStage durationMinutes(Optional<Integer> var1);

        public _FinalStage durationMinutes(Integer var1);

        public _FinalStage durationMinutes(Nullable<Integer> var1);

        public _FinalStage serviceVariationId(Optional<String> var1);

        public _FinalStage serviceVariationId(String var1);

        public _FinalStage serviceVariationId(Nullable<String> var1);

        public _FinalStage serviceVariationVersion(Optional<Long> var1);

        public _FinalStage serviceVariationVersion(Long var1);

        public _FinalStage serviceVariationVersion(Nullable<Long> var1);

        public _FinalStage intermissionMinutes(Optional<Integer> var1);

        public _FinalStage intermissionMinutes(Integer var1);

        public _FinalStage anyTeamMember(Optional<Boolean> var1);

        public _FinalStage anyTeamMember(Boolean var1);

        public _FinalStage resourceIds(Optional<List<String>> var1);

        public _FinalStage resourceIds(List<String> var1);
    }

    public static interface TeamMemberIdStage {
        public _FinalStage teamMemberId(@NotNull String var1);

        public Builder from(AppointmentSegment var1);
    }
}

