/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.BankAccountStatus;
import com.squareup.square.types.BankAccountType;
import com.squareup.square.types.Country;
import com.squareup.square.types.Currency;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BankAccount {
    private final String id;
    private final String accountNumberSuffix;
    private final Country country;
    private final Currency currency;
    private final BankAccountType accountType;
    private final String holderName;
    private final String primaryBankIdentificationNumber;
    private final Optional<String> secondaryBankIdentificationNumber;
    private final Optional<String> debitMandateReferenceId;
    private final Optional<String> referenceId;
    private final Optional<String> locationId;
    private final BankAccountStatus status;
    private final boolean creditable;
    private final boolean debitable;
    private final Optional<String> fingerprint;
    private final Optional<Integer> version;
    private final Optional<String> bankName;
    private final Map<String, Object> additionalProperties;

    private BankAccount(String id, String accountNumberSuffix, Country country, Currency currency, BankAccountType accountType, String holderName, String primaryBankIdentificationNumber, Optional<String> secondaryBankIdentificationNumber, Optional<String> debitMandateReferenceId, Optional<String> referenceId, Optional<String> locationId, BankAccountStatus status, boolean creditable, boolean debitable, Optional<String> fingerprint, Optional<Integer> version, Optional<String> bankName, Map<String, Object> additionalProperties) {
        this.id = id;
        this.accountNumberSuffix = accountNumberSuffix;
        this.country = country;
        this.currency = currency;
        this.accountType = accountType;
        this.holderName = holderName;
        this.primaryBankIdentificationNumber = primaryBankIdentificationNumber;
        this.secondaryBankIdentificationNumber = secondaryBankIdentificationNumber;
        this.debitMandateReferenceId = debitMandateReferenceId;
        this.referenceId = referenceId;
        this.locationId = locationId;
        this.status = status;
        this.creditable = creditable;
        this.debitable = debitable;
        this.fingerprint = fingerprint;
        this.version = version;
        this.bankName = bankName;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="account_number_suffix")
    public String getAccountNumberSuffix() {
        return this.accountNumberSuffix;
    }

    @JsonProperty(value="country")
    public Country getCountry() {
        return this.country;
    }

    @JsonProperty(value="currency")
    public Currency getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="account_type")
    public BankAccountType getAccountType() {
        return this.accountType;
    }

    @JsonProperty(value="holder_name")
    public String getHolderName() {
        return this.holderName;
    }

    @JsonProperty(value="primary_bank_identification_number")
    public String getPrimaryBankIdentificationNumber() {
        return this.primaryBankIdentificationNumber;
    }

    @JsonIgnore
    public Optional<String> getSecondaryBankIdentificationNumber() {
        if (this.secondaryBankIdentificationNumber == null) {
            return Optional.empty();
        }
        return this.secondaryBankIdentificationNumber;
    }

    @JsonIgnore
    public Optional<String> getDebitMandateReferenceId() {
        if (this.debitMandateReferenceId == null) {
            return Optional.empty();
        }
        return this.debitMandateReferenceId;
    }

    @JsonIgnore
    public Optional<String> getReferenceId() {
        if (this.referenceId == null) {
            return Optional.empty();
        }
        return this.referenceId;
    }

    @JsonIgnore
    public Optional<String> getLocationId() {
        if (this.locationId == null) {
            return Optional.empty();
        }
        return this.locationId;
    }

    @JsonProperty(value="status")
    public BankAccountStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="creditable")
    public boolean getCreditable() {
        return this.creditable;
    }

    @JsonProperty(value="debitable")
    public boolean getDebitable() {
        return this.debitable;
    }

    @JsonIgnore
    public Optional<String> getFingerprint() {
        if (this.fingerprint == null) {
            return Optional.empty();
        }
        return this.fingerprint;
    }

    @JsonProperty(value="version")
    public Optional<Integer> getVersion() {
        return this.version;
    }

    @JsonIgnore
    public Optional<String> getBankName() {
        if (this.bankName == null) {
            return Optional.empty();
        }
        return this.bankName;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="secondary_bank_identification_number")
    private Optional<String> _getSecondaryBankIdentificationNumber() {
        return this.secondaryBankIdentificationNumber;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="debit_mandate_reference_id")
    private Optional<String> _getDebitMandateReferenceId() {
        return this.debitMandateReferenceId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="reference_id")
    private Optional<String> _getReferenceId() {
        return this.referenceId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="location_id")
    private Optional<String> _getLocationId() {
        return this.locationId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="fingerprint")
    private Optional<String> _getFingerprint() {
        return this.fingerprint;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="bank_name")
    private Optional<String> _getBankName() {
        return this.bankName;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BankAccount && this.equalTo((BankAccount)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BankAccount other) {
        return this.id.equals(other.id) && this.accountNumberSuffix.equals(other.accountNumberSuffix) && this.country.equals(other.country) && this.currency.equals(other.currency) && this.accountType.equals(other.accountType) && this.holderName.equals(other.holderName) && this.primaryBankIdentificationNumber.equals(other.primaryBankIdentificationNumber) && this.secondaryBankIdentificationNumber.equals(other.secondaryBankIdentificationNumber) && this.debitMandateReferenceId.equals(other.debitMandateReferenceId) && this.referenceId.equals(other.referenceId) && this.locationId.equals(other.locationId) && this.status.equals(other.status) && this.creditable == other.creditable && this.debitable == other.debitable && this.fingerprint.equals(other.fingerprint) && this.version.equals(other.version) && this.bankName.equals(other.bankName);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.accountNumberSuffix, this.country, this.currency, this.accountType, this.holderName, this.primaryBankIdentificationNumber, this.secondaryBankIdentificationNumber, this.debitMandateReferenceId, this.referenceId, this.locationId, this.status, this.creditable, this.debitable, this.fingerprint, this.version, this.bankName);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    AccountNumberSuffixStage,
    CountryStage,
    CurrencyStage,
    AccountTypeStage,
    HolderNameStage,
    PrimaryBankIdentificationNumberStage,
    StatusStage,
    CreditableStage,
    DebitableStage,
    _FinalStage {
        private String id;
        private String accountNumberSuffix;
        private Country country;
        private Currency currency;
        private BankAccountType accountType;
        private String holderName;
        private String primaryBankIdentificationNumber;
        private BankAccountStatus status;
        private boolean creditable;
        private boolean debitable;
        private Optional<String> bankName = Optional.empty();
        private Optional<Integer> version = Optional.empty();
        private Optional<String> fingerprint = Optional.empty();
        private Optional<String> locationId = Optional.empty();
        private Optional<String> referenceId = Optional.empty();
        private Optional<String> debitMandateReferenceId = Optional.empty();
        private Optional<String> secondaryBankIdentificationNumber = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(BankAccount other) {
            this.id(other.getId());
            this.accountNumberSuffix(other.getAccountNumberSuffix());
            this.country(other.getCountry());
            this.currency(other.getCurrency());
            this.accountType(other.getAccountType());
            this.holderName(other.getHolderName());
            this.primaryBankIdentificationNumber(other.getPrimaryBankIdentificationNumber());
            this.secondaryBankIdentificationNumber(other.getSecondaryBankIdentificationNumber());
            this.debitMandateReferenceId(other.getDebitMandateReferenceId());
            this.referenceId(other.getReferenceId());
            this.locationId(other.getLocationId());
            this.status(other.getStatus());
            this.creditable(other.getCreditable());
            this.debitable(other.getDebitable());
            this.fingerprint(other.getFingerprint());
            this.version(other.getVersion());
            this.bankName(other.getBankName());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public AccountNumberSuffixStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="account_number_suffix")
        public CountryStage accountNumberSuffix(@NotNull String accountNumberSuffix) {
            this.accountNumberSuffix = Objects.requireNonNull(accountNumberSuffix, "accountNumberSuffix must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="country")
        public CurrencyStage country(@NotNull Country country) {
            this.country = Objects.requireNonNull(country, "country must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="currency")
        public AccountTypeStage currency(@NotNull Currency currency) {
            this.currency = Objects.requireNonNull(currency, "currency must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="account_type")
        public HolderNameStage accountType(@NotNull BankAccountType accountType) {
            this.accountType = Objects.requireNonNull(accountType, "accountType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="holder_name")
        public PrimaryBankIdentificationNumberStage holderName(@NotNull String holderName) {
            this.holderName = Objects.requireNonNull(holderName, "holderName must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="primary_bank_identification_number")
        public StatusStage primaryBankIdentificationNumber(@NotNull String primaryBankIdentificationNumber) {
            this.primaryBankIdentificationNumber = Objects.requireNonNull(primaryBankIdentificationNumber, "primaryBankIdentificationNumber must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="status")
        public CreditableStage status(@NotNull BankAccountStatus status) {
            this.status = Objects.requireNonNull(status, "status must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="creditable")
        public DebitableStage creditable(boolean creditable) {
            this.creditable = creditable;
            return this;
        }

        @Override
        @JsonSetter(value="debitable")
        public _FinalStage debitable(boolean debitable) {
            this.debitable = debitable;
            return this;
        }

        @Override
        public _FinalStage bankName(Nullable<String> bankName) {
            this.bankName = bankName.isNull() ? null : (bankName.isEmpty() ? Optional.empty() : Optional.of(bankName.get()));
            return this;
        }

        @Override
        public _FinalStage bankName(String bankName) {
            this.bankName = Optional.ofNullable(bankName);
            return this;
        }

        @Override
        @JsonSetter(value="bank_name", nulls=Nulls.SKIP)
        public _FinalStage bankName(Optional<String> bankName) {
            this.bankName = bankName;
            return this;
        }

        @Override
        public _FinalStage version(Integer version) {
            this.version = Optional.ofNullable(version);
            return this;
        }

        @Override
        @JsonSetter(value="version", nulls=Nulls.SKIP)
        public _FinalStage version(Optional<Integer> version) {
            this.version = version;
            return this;
        }

        @Override
        public _FinalStage fingerprint(Nullable<String> fingerprint) {
            this.fingerprint = fingerprint.isNull() ? null : (fingerprint.isEmpty() ? Optional.empty() : Optional.of(fingerprint.get()));
            return this;
        }

        @Override
        public _FinalStage fingerprint(String fingerprint) {
            this.fingerprint = Optional.ofNullable(fingerprint);
            return this;
        }

        @Override
        @JsonSetter(value="fingerprint", nulls=Nulls.SKIP)
        public _FinalStage fingerprint(Optional<String> fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        @Override
        public _FinalStage locationId(Nullable<String> locationId) {
            this.locationId = locationId.isNull() ? null : (locationId.isEmpty() ? Optional.empty() : Optional.of(locationId.get()));
            return this;
        }

        @Override
        public _FinalStage locationId(String locationId) {
            this.locationId = Optional.ofNullable(locationId);
            return this;
        }

        @Override
        @JsonSetter(value="location_id", nulls=Nulls.SKIP)
        public _FinalStage locationId(Optional<String> locationId) {
            this.locationId = locationId;
            return this;
        }

        @Override
        public _FinalStage referenceId(Nullable<String> referenceId) {
            this.referenceId = referenceId.isNull() ? null : (referenceId.isEmpty() ? Optional.empty() : Optional.of(referenceId.get()));
            return this;
        }

        @Override
        public _FinalStage referenceId(String referenceId) {
            this.referenceId = Optional.ofNullable(referenceId);
            return this;
        }

        @Override
        @JsonSetter(value="reference_id", nulls=Nulls.SKIP)
        public _FinalStage referenceId(Optional<String> referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        @Override
        public _FinalStage debitMandateReferenceId(Nullable<String> debitMandateReferenceId) {
            this.debitMandateReferenceId = debitMandateReferenceId.isNull() ? null : (debitMandateReferenceId.isEmpty() ? Optional.empty() : Optional.of(debitMandateReferenceId.get()));
            return this;
        }

        @Override
        public _FinalStage debitMandateReferenceId(String debitMandateReferenceId) {
            this.debitMandateReferenceId = Optional.ofNullable(debitMandateReferenceId);
            return this;
        }

        @Override
        @JsonSetter(value="debit_mandate_reference_id", nulls=Nulls.SKIP)
        public _FinalStage debitMandateReferenceId(Optional<String> debitMandateReferenceId) {
            this.debitMandateReferenceId = debitMandateReferenceId;
            return this;
        }

        @Override
        public _FinalStage secondaryBankIdentificationNumber(Nullable<String> secondaryBankIdentificationNumber) {
            this.secondaryBankIdentificationNumber = secondaryBankIdentificationNumber.isNull() ? null : (secondaryBankIdentificationNumber.isEmpty() ? Optional.empty() : Optional.of(secondaryBankIdentificationNumber.get()));
            return this;
        }

        @Override
        public _FinalStage secondaryBankIdentificationNumber(String secondaryBankIdentificationNumber) {
            this.secondaryBankIdentificationNumber = Optional.ofNullable(secondaryBankIdentificationNumber);
            return this;
        }

        @Override
        @JsonSetter(value="secondary_bank_identification_number", nulls=Nulls.SKIP)
        public _FinalStage secondaryBankIdentificationNumber(Optional<String> secondaryBankIdentificationNumber) {
            this.secondaryBankIdentificationNumber = secondaryBankIdentificationNumber;
            return this;
        }

        @Override
        public BankAccount build() {
            return new BankAccount(this.id, this.accountNumberSuffix, this.country, this.currency, this.accountType, this.holderName, this.primaryBankIdentificationNumber, this.secondaryBankIdentificationNumber, this.debitMandateReferenceId, this.referenceId, this.locationId, this.status, this.creditable, this.debitable, this.fingerprint, this.version, this.bankName, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public BankAccount build();

        public _FinalStage secondaryBankIdentificationNumber(Optional<String> var1);

        public _FinalStage secondaryBankIdentificationNumber(String var1);

        public _FinalStage secondaryBankIdentificationNumber(Nullable<String> var1);

        public _FinalStage debitMandateReferenceId(Optional<String> var1);

        public _FinalStage debitMandateReferenceId(String var1);

        public _FinalStage debitMandateReferenceId(Nullable<String> var1);

        public _FinalStage referenceId(Optional<String> var1);

        public _FinalStage referenceId(String var1);

        public _FinalStage referenceId(Nullable<String> var1);

        public _FinalStage locationId(Optional<String> var1);

        public _FinalStage locationId(String var1);

        public _FinalStage locationId(Nullable<String> var1);

        public _FinalStage fingerprint(Optional<String> var1);

        public _FinalStage fingerprint(String var1);

        public _FinalStage fingerprint(Nullable<String> var1);

        public _FinalStage version(Optional<Integer> var1);

        public _FinalStage version(Integer var1);

        public _FinalStage bankName(Optional<String> var1);

        public _FinalStage bankName(String var1);

        public _FinalStage bankName(Nullable<String> var1);
    }

    public static interface DebitableStage {
        public _FinalStage debitable(boolean var1);
    }

    public static interface CreditableStage {
        public DebitableStage creditable(boolean var1);
    }

    public static interface StatusStage {
        public CreditableStage status(@NotNull BankAccountStatus var1);
    }

    public static interface PrimaryBankIdentificationNumberStage {
        public StatusStage primaryBankIdentificationNumber(@NotNull String var1);
    }

    public static interface HolderNameStage {
        public PrimaryBankIdentificationNumberStage holderName(@NotNull String var1);
    }

    public static interface AccountTypeStage {
        public HolderNameStage accountType(@NotNull BankAccountType var1);
    }

    public static interface CurrencyStage {
        public AccountTypeStage currency(@NotNull Currency var1);
    }

    public static interface CountryStage {
        public CurrencyStage country(@NotNull Country var1);
    }

    public static interface AccountNumberSuffixStage {
        public CountryStage accountNumberSuffix(@NotNull String var1);
    }

    public static interface IdStage {
        public AccountNumberSuffixStage id(@NotNull String var1);

        public Builder from(BankAccount var1);
    }
}

