/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.AchDetails;
import com.squareup.square.types.Error;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BankAccountPaymentDetails {
    private final Optional<String> bankName;
    private final Optional<String> transferType;
    private final Optional<String> accountOwnershipType;
    private final Optional<String> fingerprint;
    private final Optional<String> country;
    private final Optional<String> statementDescription;
    private final Optional<AchDetails> achDetails;
    private final Optional<List<Error>> errors;
    private final Map<String, Object> additionalProperties;

    private BankAccountPaymentDetails(Optional<String> bankName, Optional<String> transferType, Optional<String> accountOwnershipType, Optional<String> fingerprint, Optional<String> country, Optional<String> statementDescription, Optional<AchDetails> achDetails, Optional<List<Error>> errors, Map<String, Object> additionalProperties) {
        this.bankName = bankName;
        this.transferType = transferType;
        this.accountOwnershipType = accountOwnershipType;
        this.fingerprint = fingerprint;
        this.country = country;
        this.statementDescription = statementDescription;
        this.achDetails = achDetails;
        this.errors = errors;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getBankName() {
        if (this.bankName == null) {
            return Optional.empty();
        }
        return this.bankName;
    }

    @JsonIgnore
    public Optional<String> getTransferType() {
        if (this.transferType == null) {
            return Optional.empty();
        }
        return this.transferType;
    }

    @JsonIgnore
    public Optional<String> getAccountOwnershipType() {
        if (this.accountOwnershipType == null) {
            return Optional.empty();
        }
        return this.accountOwnershipType;
    }

    @JsonIgnore
    public Optional<String> getFingerprint() {
        if (this.fingerprint == null) {
            return Optional.empty();
        }
        return this.fingerprint;
    }

    @JsonIgnore
    public Optional<String> getCountry() {
        if (this.country == null) {
            return Optional.empty();
        }
        return this.country;
    }

    @JsonIgnore
    public Optional<String> getStatementDescription() {
        if (this.statementDescription == null) {
            return Optional.empty();
        }
        return this.statementDescription;
    }

    @JsonProperty(value="ach_details")
    public Optional<AchDetails> getAchDetails() {
        return this.achDetails;
    }

    @JsonIgnore
    public Optional<List<Error>> getErrors() {
        if (this.errors == null) {
            return Optional.empty();
        }
        return this.errors;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="bank_name")
    private Optional<String> _getBankName() {
        return this.bankName;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="transfer_type")
    private Optional<String> _getTransferType() {
        return this.transferType;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="account_ownership_type")
    private Optional<String> _getAccountOwnershipType() {
        return this.accountOwnershipType;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="fingerprint")
    private Optional<String> _getFingerprint() {
        return this.fingerprint;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="country")
    private Optional<String> _getCountry() {
        return this.country;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="statement_description")
    private Optional<String> _getStatementDescription() {
        return this.statementDescription;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="errors")
    private Optional<List<Error>> _getErrors() {
        return this.errors;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BankAccountPaymentDetails && this.equalTo((BankAccountPaymentDetails)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BankAccountPaymentDetails other) {
        return this.bankName.equals(other.bankName) && this.transferType.equals(other.transferType) && this.accountOwnershipType.equals(other.accountOwnershipType) && this.fingerprint.equals(other.fingerprint) && this.country.equals(other.country) && this.statementDescription.equals(other.statementDescription) && this.achDetails.equals(other.achDetails) && this.errors.equals(other.errors);
    }

    public int hashCode() {
        return Objects.hash(this.bankName, this.transferType, this.accountOwnershipType, this.fingerprint, this.country, this.statementDescription, this.achDetails, this.errors);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> bankName = Optional.empty();
        private Optional<String> transferType = Optional.empty();
        private Optional<String> accountOwnershipType = Optional.empty();
        private Optional<String> fingerprint = Optional.empty();
        private Optional<String> country = Optional.empty();
        private Optional<String> statementDescription = Optional.empty();
        private Optional<AchDetails> achDetails = Optional.empty();
        private Optional<List<Error>> errors = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(BankAccountPaymentDetails other) {
            this.bankName(other.getBankName());
            this.transferType(other.getTransferType());
            this.accountOwnershipType(other.getAccountOwnershipType());
            this.fingerprint(other.getFingerprint());
            this.country(other.getCountry());
            this.statementDescription(other.getStatementDescription());
            this.achDetails(other.getAchDetails());
            this.errors(other.getErrors());
            return this;
        }

        @JsonSetter(value="bank_name", nulls=Nulls.SKIP)
        public Builder bankName(Optional<String> bankName) {
            this.bankName = bankName;
            return this;
        }

        public Builder bankName(String bankName) {
            this.bankName = Optional.ofNullable(bankName);
            return this;
        }

        public Builder bankName(Nullable<String> bankName) {
            this.bankName = bankName.isNull() ? null : (bankName.isEmpty() ? Optional.empty() : Optional.of(bankName.get()));
            return this;
        }

        @JsonSetter(value="transfer_type", nulls=Nulls.SKIP)
        public Builder transferType(Optional<String> transferType) {
            this.transferType = transferType;
            return this;
        }

        public Builder transferType(String transferType) {
            this.transferType = Optional.ofNullable(transferType);
            return this;
        }

        public Builder transferType(Nullable<String> transferType) {
            this.transferType = transferType.isNull() ? null : (transferType.isEmpty() ? Optional.empty() : Optional.of(transferType.get()));
            return this;
        }

        @JsonSetter(value="account_ownership_type", nulls=Nulls.SKIP)
        public Builder accountOwnershipType(Optional<String> accountOwnershipType) {
            this.accountOwnershipType = accountOwnershipType;
            return this;
        }

        public Builder accountOwnershipType(String accountOwnershipType) {
            this.accountOwnershipType = Optional.ofNullable(accountOwnershipType);
            return this;
        }

        public Builder accountOwnershipType(Nullable<String> accountOwnershipType) {
            this.accountOwnershipType = accountOwnershipType.isNull() ? null : (accountOwnershipType.isEmpty() ? Optional.empty() : Optional.of(accountOwnershipType.get()));
            return this;
        }

        @JsonSetter(value="fingerprint", nulls=Nulls.SKIP)
        public Builder fingerprint(Optional<String> fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public Builder fingerprint(String fingerprint) {
            this.fingerprint = Optional.ofNullable(fingerprint);
            return this;
        }

        public Builder fingerprint(Nullable<String> fingerprint) {
            this.fingerprint = fingerprint.isNull() ? null : (fingerprint.isEmpty() ? Optional.empty() : Optional.of(fingerprint.get()));
            return this;
        }

        @JsonSetter(value="country", nulls=Nulls.SKIP)
        public Builder country(Optional<String> country) {
            this.country = country;
            return this;
        }

        public Builder country(String country) {
            this.country = Optional.ofNullable(country);
            return this;
        }

        public Builder country(Nullable<String> country) {
            this.country = country.isNull() ? null : (country.isEmpty() ? Optional.empty() : Optional.of(country.get()));
            return this;
        }

        @JsonSetter(value="statement_description", nulls=Nulls.SKIP)
        public Builder statementDescription(Optional<String> statementDescription) {
            this.statementDescription = statementDescription;
            return this;
        }

        public Builder statementDescription(String statementDescription) {
            this.statementDescription = Optional.ofNullable(statementDescription);
            return this;
        }

        public Builder statementDescription(Nullable<String> statementDescription) {
            this.statementDescription = statementDescription.isNull() ? null : (statementDescription.isEmpty() ? Optional.empty() : Optional.of(statementDescription.get()));
            return this;
        }

        @JsonSetter(value="ach_details", nulls=Nulls.SKIP)
        public Builder achDetails(Optional<AchDetails> achDetails) {
            this.achDetails = achDetails;
            return this;
        }

        public Builder achDetails(AchDetails achDetails) {
            this.achDetails = Optional.ofNullable(achDetails);
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        public Builder errors(Nullable<List<Error>> errors) {
            this.errors = errors.isNull() ? null : (errors.isEmpty() ? Optional.empty() : Optional.of(errors.get()));
            return this;
        }

        public BankAccountPaymentDetails build() {
            return new BankAccountPaymentDetails(this.bankName, this.transferType, this.accountOwnershipType, this.fingerprint, this.country, this.statementDescription, this.achDetails, this.errors, this.additionalProperties);
        }
    }
}

