/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class BankAccountType {
    public static final BankAccountType SAVINGS = new BankAccountType(Value.SAVINGS, "SAVINGS");
    public static final BankAccountType OTHER = new BankAccountType(Value.OTHER, "OTHER");
    public static final BankAccountType BUSINESS_CHECKING = new BankAccountType(Value.BUSINESS_CHECKING, "BUSINESS_CHECKING");
    public static final BankAccountType INVESTMENT = new BankAccountType(Value.INVESTMENT, "INVESTMENT");
    public static final BankAccountType CHECKING = new BankAccountType(Value.CHECKING, "CHECKING");
    private final Value value;
    private final String string;

    BankAccountType(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof BankAccountType && this.string.equals(((BankAccountType)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case SAVINGS: {
                return visitor.visitSavings();
            }
            case OTHER: {
                return visitor.visitOther();
            }
            case BUSINESS_CHECKING: {
                return visitor.visitBusinessChecking();
            }
            case INVESTMENT: {
                return visitor.visitInvestment();
            }
            case CHECKING: {
                return visitor.visitChecking();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static BankAccountType valueOf(String value) {
        switch (value) {
            case "SAVINGS": {
                return SAVINGS;
            }
            case "OTHER": {
                return OTHER;
            }
            case "BUSINESS_CHECKING": {
                return BUSINESS_CHECKING;
            }
            case "INVESTMENT": {
                return INVESTMENT;
            }
            case "CHECKING": {
                return CHECKING;
            }
        }
        return new BankAccountType(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitChecking();

        public T visitSavings();

        public T visitInvestment();

        public T visitOther();

        public T visitBusinessChecking();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        CHECKING,
        SAVINGS,
        INVESTMENT,
        OTHER,
        BUSINESS_CHECKING,
        UNKNOWN;

    }
}

