/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BatchDeleteCatalogObjectsRequest {
    private final List<String> objectIds;
    private final Map<String, Object> additionalProperties;

    private BatchDeleteCatalogObjectsRequest(List<String> objectIds, Map<String, Object> additionalProperties) {
        this.objectIds = objectIds;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="object_ids")
    public List<String> getObjectIds() {
        return this.objectIds;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BatchDeleteCatalogObjectsRequest && this.equalTo((BatchDeleteCatalogObjectsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BatchDeleteCatalogObjectsRequest other) {
        return this.objectIds.equals(other.objectIds);
    }

    public int hashCode() {
        return Objects.hash(this.objectIds);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private List<String> objectIds = new ArrayList<String>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(BatchDeleteCatalogObjectsRequest other) {
            this.objectIds(other.getObjectIds());
            return this;
        }

        @JsonSetter(value="object_ids", nulls=Nulls.SKIP)
        public Builder objectIds(List<String> objectIds) {
            this.objectIds.clear();
            this.objectIds.addAll(objectIds);
            return this;
        }

        public Builder addObjectIds(String objectIds) {
            this.objectIds.add(objectIds);
            return this;
        }

        public Builder addAllObjectIds(List<String> objectIds) {
            this.objectIds.addAll(objectIds);
            return this;
        }

        public BatchDeleteCatalogObjectsRequest build() {
            return new BatchDeleteCatalogObjectsRequest(this.objectIds, this.additionalProperties);
        }
    }
}

