/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CatalogObject;
import com.squareup.square.types.Error;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BatchGetCatalogObjectsResponse {
    private final Optional<List<Error>> errors;
    private final Optional<List<CatalogObject>> objects;
    private final Optional<List<CatalogObject>> relatedObjects;
    private final Map<String, Object> additionalProperties;

    private BatchGetCatalogObjectsResponse(Optional<List<Error>> errors, Optional<List<CatalogObject>> objects, Optional<List<CatalogObject>> relatedObjects, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.objects = objects;
        this.relatedObjects = relatedObjects;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="objects")
    public Optional<List<CatalogObject>> getObjects() {
        return this.objects;
    }

    @JsonProperty(value="related_objects")
    public Optional<List<CatalogObject>> getRelatedObjects() {
        return this.relatedObjects;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BatchGetCatalogObjectsResponse && this.equalTo((BatchGetCatalogObjectsResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BatchGetCatalogObjectsResponse other) {
        return this.errors.equals(other.errors) && this.objects.equals(other.objects) && this.relatedObjects.equals(other.relatedObjects);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.objects, this.relatedObjects);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<List<CatalogObject>> objects = Optional.empty();
        private Optional<List<CatalogObject>> relatedObjects = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(BatchGetCatalogObjectsResponse other) {
            this.errors(other.getErrors());
            this.objects(other.getObjects());
            this.relatedObjects(other.getRelatedObjects());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="objects", nulls=Nulls.SKIP)
        public Builder objects(Optional<List<CatalogObject>> objects) {
            this.objects = objects;
            return this;
        }

        public Builder objects(List<CatalogObject> objects) {
            this.objects = Optional.ofNullable(objects);
            return this;
        }

        @JsonSetter(value="related_objects", nulls=Nulls.SKIP)
        public Builder relatedObjects(Optional<List<CatalogObject>> relatedObjects) {
            this.relatedObjects = relatedObjects;
            return this;
        }

        public Builder relatedObjects(List<CatalogObject> relatedObjects) {
            this.relatedObjects = Optional.ofNullable(relatedObjects);
            return this;
        }

        public BatchGetCatalogObjectsResponse build() {
            return new BatchGetCatalogObjectsResponse(this.errors, this.objects, this.relatedObjects, this.additionalProperties);
        }
    }
}

