/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import com.squareup.square.types.GetVendorResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BatchGetVendorsResponse {
    private final Optional<List<Error>> errors;
    private final Optional<Map<String, GetVendorResponse>> responses;
    private final Map<String, Object> additionalProperties;

    private BatchGetVendorsResponse(Optional<List<Error>> errors, Optional<Map<String, GetVendorResponse>> responses, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.responses = responses;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="responses")
    public Optional<Map<String, GetVendorResponse>> getResponses() {
        return this.responses;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BatchGetVendorsResponse && this.equalTo((BatchGetVendorsResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BatchGetVendorsResponse other) {
        return this.errors.equals(other.errors) && this.responses.equals(other.responses);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.responses);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<Map<String, GetVendorResponse>> responses = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(BatchGetVendorsResponse other) {
            this.errors(other.getErrors());
            this.responses(other.getResponses());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="responses", nulls=Nulls.SKIP)
        public Builder responses(Optional<Map<String, GetVendorResponse>> responses) {
            this.responses = responses;
            return this;
        }

        public Builder responses(Map<String, GetVendorResponse> responses) {
            this.responses = Optional.ofNullable(responses);
            return this;
        }

        public BatchGetVendorsResponse build() {
            return new BatchGetVendorsResponse(this.errors, this.responses, this.additionalProperties);
        }
    }
}

