/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import com.squareup.square.types.UpdateTeamMemberResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BatchUpdateTeamMembersResponse {
    private final Optional<Map<String, UpdateTeamMemberResponse>> teamMembers;
    private final Optional<List<Error>> errors;
    private final Map<String, Object> additionalProperties;

    private BatchUpdateTeamMembersResponse(Optional<Map<String, UpdateTeamMemberResponse>> teamMembers, Optional<List<Error>> errors, Map<String, Object> additionalProperties) {
        this.teamMembers = teamMembers;
        this.errors = errors;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="team_members")
    public Optional<Map<String, UpdateTeamMemberResponse>> getTeamMembers() {
        return this.teamMembers;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BatchUpdateTeamMembersResponse && this.equalTo((BatchUpdateTeamMembersResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BatchUpdateTeamMembersResponse other) {
        return this.teamMembers.equals(other.teamMembers) && this.errors.equals(other.errors);
    }

    public int hashCode() {
        return Objects.hash(this.teamMembers, this.errors);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Map<String, UpdateTeamMemberResponse>> teamMembers = Optional.empty();
        private Optional<List<Error>> errors = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(BatchUpdateTeamMembersResponse other) {
            this.teamMembers(other.getTeamMembers());
            this.errors(other.getErrors());
            return this;
        }

        @JsonSetter(value="team_members", nulls=Nulls.SKIP)
        public Builder teamMembers(Optional<Map<String, UpdateTeamMemberResponse>> teamMembers) {
            this.teamMembers = teamMembers;
            return this;
        }

        public Builder teamMembers(Map<String, UpdateTeamMemberResponse> teamMembers) {
            this.teamMembers = Optional.ofNullable(teamMembers);
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        public BatchUpdateTeamMembersResponse build() {
            return new BatchUpdateTeamMembersResponse(this.teamMembers, this.errors, this.additionalProperties);
        }
    }
}

