/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.UpdateVendorRequest;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BatchUpdateVendorsRequest {
    private final Map<String, UpdateVendorRequest> vendors;
    private final Map<String, Object> additionalProperties;

    private BatchUpdateVendorsRequest(Map<String, UpdateVendorRequest> vendors, Map<String, Object> additionalProperties) {
        this.vendors = vendors;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="vendors")
    public Map<String, UpdateVendorRequest> getVendors() {
        return this.vendors;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BatchUpdateVendorsRequest && this.equalTo((BatchUpdateVendorsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BatchUpdateVendorsRequest other) {
        return this.vendors.equals(other.vendors);
    }

    public int hashCode() {
        return Objects.hash(this.vendors);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Map<String, UpdateVendorRequest> vendors = new LinkedHashMap<String, UpdateVendorRequest>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(BatchUpdateVendorsRequest other) {
            this.vendors(other.getVendors());
            return this;
        }

        @JsonSetter(value="vendors", nulls=Nulls.SKIP)
        public Builder vendors(Map<String, UpdateVendorRequest> vendors) {
            this.vendors.clear();
            this.vendors.putAll(vendors);
            return this;
        }

        public Builder putAllVendors(Map<String, UpdateVendorRequest> vendors) {
            this.vendors.putAll(vendors);
            return this;
        }

        public Builder vendors(String key, UpdateVendorRequest value) {
            this.vendors.put(key, value);
            return this;
        }

        public BatchUpdateVendorsRequest build() {
            return new BatchUpdateVendorsRequest(this.vendors, this.additionalProperties);
        }
    }
}

