/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CatalogIdMapping;
import com.squareup.square.types.CatalogObject;
import com.squareup.square.types.Error;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BatchUpsertCatalogObjectsResponse {
    private final Optional<List<Error>> errors;
    private final Optional<List<CatalogObject>> objects;
    private final Optional<String> updatedAt;
    private final Optional<List<CatalogIdMapping>> idMappings;
    private final Map<String, Object> additionalProperties;

    private BatchUpsertCatalogObjectsResponse(Optional<List<Error>> errors, Optional<List<CatalogObject>> objects, Optional<String> updatedAt, Optional<List<CatalogIdMapping>> idMappings, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.objects = objects;
        this.updatedAt = updatedAt;
        this.idMappings = idMappings;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="objects")
    public Optional<List<CatalogObject>> getObjects() {
        return this.objects;
    }

    @JsonProperty(value="updated_at")
    public Optional<String> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="id_mappings")
    public Optional<List<CatalogIdMapping>> getIdMappings() {
        return this.idMappings;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BatchUpsertCatalogObjectsResponse && this.equalTo((BatchUpsertCatalogObjectsResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BatchUpsertCatalogObjectsResponse other) {
        return this.errors.equals(other.errors) && this.objects.equals(other.objects) && this.updatedAt.equals(other.updatedAt) && this.idMappings.equals(other.idMappings);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.objects, this.updatedAt, this.idMappings);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<List<CatalogObject>> objects = Optional.empty();
        private Optional<String> updatedAt = Optional.empty();
        private Optional<List<CatalogIdMapping>> idMappings = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(BatchUpsertCatalogObjectsResponse other) {
            this.errors(other.getErrors());
            this.objects(other.getObjects());
            this.updatedAt(other.getUpdatedAt());
            this.idMappings(other.getIdMappings());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="objects", nulls=Nulls.SKIP)
        public Builder objects(Optional<List<CatalogObject>> objects) {
            this.objects = objects;
            return this;
        }

        public Builder objects(List<CatalogObject> objects) {
            this.objects = Optional.ofNullable(objects);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<String> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @JsonSetter(value="id_mappings", nulls=Nulls.SKIP)
        public Builder idMappings(Optional<List<CatalogIdMapping>> idMappings) {
            this.idMappings = idMappings;
            return this;
        }

        public Builder idMappings(List<CatalogIdMapping> idMappings) {
            this.idMappings = Optional.ofNullable(idMappings);
            return this;
        }

        public BatchUpsertCatalogObjectsResponse build() {
            return new BatchUpsertCatalogObjectsResponse(this.errors, this.objects, this.updatedAt, this.idMappings, this.additionalProperties);
        }
    }
}

