/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class BookingStatus {
    public static final BookingStatus CANCELLED_BY_SELLER = new BookingStatus(Value.CANCELLED_BY_SELLER, "CANCELLED_BY_SELLER");
    public static final BookingStatus ACCEPTED = new BookingStatus(Value.ACCEPTED, "ACCEPTED");
    public static final BookingStatus CANCELLED_BY_CUSTOMER = new BookingStatus(Value.CANCELLED_BY_CUSTOMER, "CANCELLED_BY_CUSTOMER");
    public static final BookingStatus DECLINED = new BookingStatus(Value.DECLINED, "DECLINED");
    public static final BookingStatus NO_SHOW = new BookingStatus(Value.NO_SHOW, "NO_SHOW");
    public static final BookingStatus PENDING = new BookingStatus(Value.PENDING, "PENDING");
    private final Value value;
    private final String string;

    BookingStatus(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof BookingStatus && this.string.equals(((BookingStatus)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case CANCELLED_BY_SELLER: {
                return visitor.visitCancelledBySeller();
            }
            case ACCEPTED: {
                return visitor.visitAccepted();
            }
            case CANCELLED_BY_CUSTOMER: {
                return visitor.visitCancelledByCustomer();
            }
            case DECLINED: {
                return visitor.visitDeclined();
            }
            case NO_SHOW: {
                return visitor.visitNoShow();
            }
            case PENDING: {
                return visitor.visitPending();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static BookingStatus valueOf(String value) {
        switch (value) {
            case "CANCELLED_BY_SELLER": {
                return CANCELLED_BY_SELLER;
            }
            case "ACCEPTED": {
                return ACCEPTED;
            }
            case "CANCELLED_BY_CUSTOMER": {
                return CANCELLED_BY_CUSTOMER;
            }
            case "DECLINED": {
                return DECLINED;
            }
            case "NO_SHOW": {
                return NO_SHOW;
            }
            case "PENDING": {
                return PENDING;
            }
        }
        return new BookingStatus(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitPending();

        public T visitCancelledByCustomer();

        public T visitCancelledBySeller();

        public T visitDeclined();

        public T visitAccepted();

        public T visitNoShow();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        PENDING,
        CANCELLED_BY_CUSTOMER,
        CANCELLED_BY_SELLER,
        DECLINED,
        ACCEPTED,
        NO_SHOW,
        UNKNOWN;

    }
}

