/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Break {
    private final Optional<String> id;
    private final String startAt;
    private final Optional<String> endAt;
    private final String breakTypeId;
    private final String name;
    private final String expectedDuration;
    private final boolean isPaid;
    private final Map<String, Object> additionalProperties;

    private Break(Optional<String> id, String startAt, Optional<String> endAt, String breakTypeId, String name, String expectedDuration, boolean isPaid, Map<String, Object> additionalProperties) {
        this.id = id;
        this.startAt = startAt;
        this.endAt = endAt;
        this.breakTypeId = breakTypeId;
        this.name = name;
        this.expectedDuration = expectedDuration;
        this.isPaid = isPaid;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="start_at")
    public String getStartAt() {
        return this.startAt;
    }

    @JsonIgnore
    public Optional<String> getEndAt() {
        if (this.endAt == null) {
            return Optional.empty();
        }
        return this.endAt;
    }

    @JsonProperty(value="break_type_id")
    public String getBreakTypeId() {
        return this.breakTypeId;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="expected_duration")
    public String getExpectedDuration() {
        return this.expectedDuration;
    }

    @JsonProperty(value="is_paid")
    public boolean getIsPaid() {
        return this.isPaid;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="end_at")
    private Optional<String> _getEndAt() {
        return this.endAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Break && this.equalTo((Break)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Break other) {
        return this.id.equals(other.id) && this.startAt.equals(other.startAt) && this.endAt.equals(other.endAt) && this.breakTypeId.equals(other.breakTypeId) && this.name.equals(other.name) && this.expectedDuration.equals(other.expectedDuration) && this.isPaid == other.isPaid;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.startAt, this.endAt, this.breakTypeId, this.name, this.expectedDuration, this.isPaid);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static StartAtStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements StartAtStage,
    BreakTypeIdStage,
    NameStage,
    ExpectedDurationStage,
    IsPaidStage,
    _FinalStage {
        private String startAt;
        private String breakTypeId;
        private String name;
        private String expectedDuration;
        private boolean isPaid;
        private Optional<String> endAt = Optional.empty();
        private Optional<String> id = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Break other) {
            this.id(other.getId());
            this.startAt(other.getStartAt());
            this.endAt(other.getEndAt());
            this.breakTypeId(other.getBreakTypeId());
            this.name(other.getName());
            this.expectedDuration(other.getExpectedDuration());
            this.isPaid(other.getIsPaid());
            return this;
        }

        @Override
        @JsonSetter(value="start_at")
        public BreakTypeIdStage startAt(@NotNull String startAt) {
            this.startAt = Objects.requireNonNull(startAt, "startAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="break_type_id")
        public NameStage breakTypeId(@NotNull String breakTypeId) {
            this.breakTypeId = Objects.requireNonNull(breakTypeId, "breakTypeId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public ExpectedDurationStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="expected_duration")
        public IsPaidStage expectedDuration(@NotNull String expectedDuration) {
            this.expectedDuration = Objects.requireNonNull(expectedDuration, "expectedDuration must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="is_paid")
        public _FinalStage isPaid(boolean isPaid) {
            this.isPaid = isPaid;
            return this;
        }

        @Override
        public _FinalStage endAt(Nullable<String> endAt) {
            this.endAt = endAt.isNull() ? null : (endAt.isEmpty() ? Optional.empty() : Optional.of(endAt.get()));
            return this;
        }

        @Override
        public _FinalStage endAt(String endAt) {
            this.endAt = Optional.ofNullable(endAt);
            return this;
        }

        @Override
        @JsonSetter(value="end_at", nulls=Nulls.SKIP)
        public _FinalStage endAt(Optional<String> endAt) {
            this.endAt = endAt;
            return this;
        }

        @Override
        public _FinalStage id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @Override
        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public _FinalStage id(Optional<String> id) {
            this.id = id;
            return this;
        }

        @Override
        public Break build() {
            return new Break(this.id, this.startAt, this.endAt, this.breakTypeId, this.name, this.expectedDuration, this.isPaid, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Break build();

        public _FinalStage id(Optional<String> var1);

        public _FinalStage id(String var1);

        public _FinalStage endAt(Optional<String> var1);

        public _FinalStage endAt(String var1);

        public _FinalStage endAt(Nullable<String> var1);
    }

    public static interface IsPaidStage {
        public _FinalStage isPaid(boolean var1);
    }

    public static interface ExpectedDurationStage {
        public IsPaidStage expectedDuration(@NotNull String var1);
    }

    public static interface NameStage {
        public ExpectedDurationStage name(@NotNull String var1);
    }

    public static interface BreakTypeIdStage {
        public NameStage breakTypeId(@NotNull String var1);
    }

    public static interface StartAtStage {
        public BreakTypeIdStage startAt(@NotNull String var1);

        public Builder from(Break var1);
    }
}

