/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BulkDeleteOrderCustomAttributesRequestDeleteCustomAttribute {
    private final Optional<String> key;
    private final String orderId;
    private final Map<String, Object> additionalProperties;

    private BulkDeleteOrderCustomAttributesRequestDeleteCustomAttribute(Optional<String> key, String orderId, Map<String, Object> additionalProperties) {
        this.key = key;
        this.orderId = orderId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="key")
    public Optional<String> getKey() {
        return this.key;
    }

    @JsonProperty(value="order_id")
    public String getOrderId() {
        return this.orderId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BulkDeleteOrderCustomAttributesRequestDeleteCustomAttribute && this.equalTo((BulkDeleteOrderCustomAttributesRequestDeleteCustomAttribute)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BulkDeleteOrderCustomAttributesRequestDeleteCustomAttribute other) {
        return this.key.equals(other.key) && this.orderId.equals(other.orderId);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.orderId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static OrderIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements OrderIdStage,
    _FinalStage {
        private String orderId;
        private Optional<String> key = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(BulkDeleteOrderCustomAttributesRequestDeleteCustomAttribute other) {
            this.key(other.getKey());
            this.orderId(other.getOrderId());
            return this;
        }

        @Override
        @JsonSetter(value="order_id")
        public _FinalStage orderId(@NotNull String orderId) {
            this.orderId = Objects.requireNonNull(orderId, "orderId must not be null");
            return this;
        }

        @Override
        public _FinalStage key(String key) {
            this.key = Optional.ofNullable(key);
            return this;
        }

        @Override
        @JsonSetter(value="key", nulls=Nulls.SKIP)
        public _FinalStage key(Optional<String> key) {
            this.key = key;
            return this;
        }

        @Override
        public BulkDeleteOrderCustomAttributesRequestDeleteCustomAttribute build() {
            return new BulkDeleteOrderCustomAttributesRequestDeleteCustomAttribute(this.key, this.orderId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public BulkDeleteOrderCustomAttributesRequestDeleteCustomAttribute build();

        public _FinalStage key(Optional<String> var1);

        public _FinalStage key(String var1);
    }

    public static interface OrderIdStage {
        public _FinalStage orderId(@NotNull String var1);

        public Builder from(BulkDeleteOrderCustomAttributesRequestDeleteCustomAttribute var1);
    }
}

