/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.DeleteOrderCustomAttributeResponse;
import com.squareup.square.types.Error;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BulkDeleteOrderCustomAttributesResponse {
    private final Optional<List<Error>> errors;
    private final Map<String, DeleteOrderCustomAttributeResponse> values;
    private final Map<String, Object> additionalProperties;

    private BulkDeleteOrderCustomAttributesResponse(Optional<List<Error>> errors, Map<String, DeleteOrderCustomAttributeResponse> values, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.values = values;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="values")
    public Map<String, DeleteOrderCustomAttributeResponse> getValues() {
        return this.values;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BulkDeleteOrderCustomAttributesResponse && this.equalTo((BulkDeleteOrderCustomAttributesResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BulkDeleteOrderCustomAttributesResponse other) {
        return this.errors.equals(other.errors) && this.values.equals(other.values);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.values);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Map<String, DeleteOrderCustomAttributeResponse> values = new LinkedHashMap<String, DeleteOrderCustomAttributeResponse>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(BulkDeleteOrderCustomAttributesResponse other) {
            this.errors(other.getErrors());
            this.values(other.getValues());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="values", nulls=Nulls.SKIP)
        public Builder values(Map<String, DeleteOrderCustomAttributeResponse> values) {
            this.values.clear();
            this.values.putAll(values);
            return this;
        }

        public Builder putAllValues(Map<String, DeleteOrderCustomAttributeResponse> values) {
            this.values.putAll(values);
            return this;
        }

        public Builder values(String key, DeleteOrderCustomAttributeResponse value) {
            this.values.put(key, value);
            return this;
        }

        public BulkDeleteOrderCustomAttributesResponse build() {
            return new BulkDeleteOrderCustomAttributesResponse(this.errors, this.values, this.additionalProperties);
        }
    }
}

