/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BulkRetrieveBookingsRequest {
    private final List<String> bookingIds;
    private final Map<String, Object> additionalProperties;

    private BulkRetrieveBookingsRequest(List<String> bookingIds, Map<String, Object> additionalProperties) {
        this.bookingIds = bookingIds;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="booking_ids")
    public List<String> getBookingIds() {
        return this.bookingIds;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BulkRetrieveBookingsRequest && this.equalTo((BulkRetrieveBookingsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BulkRetrieveBookingsRequest other) {
        return this.bookingIds.equals(other.bookingIds);
    }

    public int hashCode() {
        return Objects.hash(this.bookingIds);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private List<String> bookingIds = new ArrayList<String>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(BulkRetrieveBookingsRequest other) {
            this.bookingIds(other.getBookingIds());
            return this;
        }

        @JsonSetter(value="booking_ids", nulls=Nulls.SKIP)
        public Builder bookingIds(List<String> bookingIds) {
            this.bookingIds.clear();
            this.bookingIds.addAll(bookingIds);
            return this;
        }

        public Builder addBookingIds(String bookingIds) {
            this.bookingIds.add(bookingIds);
            return this;
        }

        public Builder addAllBookingIds(List<String> bookingIds) {
            this.bookingIds.addAll(bookingIds);
            return this;
        }

        public BulkRetrieveBookingsRequest build() {
            return new BulkRetrieveBookingsRequest(this.bookingIds, this.additionalProperties);
        }
    }
}

