/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BulkSwapPlanRequest {
    private final String newPlanVariationId;
    private final String oldPlanVariationId;
    private final String locationId;
    private final Map<String, Object> additionalProperties;

    private BulkSwapPlanRequest(String newPlanVariationId, String oldPlanVariationId, String locationId, Map<String, Object> additionalProperties) {
        this.newPlanVariationId = newPlanVariationId;
        this.oldPlanVariationId = oldPlanVariationId;
        this.locationId = locationId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="new_plan_variation_id")
    public String getNewPlanVariationId() {
        return this.newPlanVariationId;
    }

    @JsonProperty(value="old_plan_variation_id")
    public String getOldPlanVariationId() {
        return this.oldPlanVariationId;
    }

    @JsonProperty(value="location_id")
    public String getLocationId() {
        return this.locationId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BulkSwapPlanRequest && this.equalTo((BulkSwapPlanRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BulkSwapPlanRequest other) {
        return this.newPlanVariationId.equals(other.newPlanVariationId) && this.oldPlanVariationId.equals(other.oldPlanVariationId) && this.locationId.equals(other.locationId);
    }

    public int hashCode() {
        return Objects.hash(this.newPlanVariationId, this.oldPlanVariationId, this.locationId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NewPlanVariationIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NewPlanVariationIdStage,
    OldPlanVariationIdStage,
    LocationIdStage,
    _FinalStage {
        private String newPlanVariationId;
        private String oldPlanVariationId;
        private String locationId;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(BulkSwapPlanRequest other) {
            this.newPlanVariationId(other.getNewPlanVariationId());
            this.oldPlanVariationId(other.getOldPlanVariationId());
            this.locationId(other.getLocationId());
            return this;
        }

        @Override
        @JsonSetter(value="new_plan_variation_id")
        public OldPlanVariationIdStage newPlanVariationId(@NotNull String newPlanVariationId) {
            this.newPlanVariationId = Objects.requireNonNull(newPlanVariationId, "newPlanVariationId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="old_plan_variation_id")
        public LocationIdStage oldPlanVariationId(@NotNull String oldPlanVariationId) {
            this.oldPlanVariationId = Objects.requireNonNull(oldPlanVariationId, "oldPlanVariationId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="location_id")
        public _FinalStage locationId(@NotNull String locationId) {
            this.locationId = Objects.requireNonNull(locationId, "locationId must not be null");
            return this;
        }

        @Override
        public BulkSwapPlanRequest build() {
            return new BulkSwapPlanRequest(this.newPlanVariationId, this.oldPlanVariationId, this.locationId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public BulkSwapPlanRequest build();
    }

    public static interface LocationIdStage {
        public _FinalStage locationId(@NotNull String var1);
    }

    public static interface OldPlanVariationIdStage {
        public LocationIdStage oldPlanVariationId(@NotNull String var1);
    }

    public static interface NewPlanVariationIdStage {
        public OldPlanVariationIdStage newPlanVariationId(@NotNull String var1);

        public Builder from(BulkSwapPlanRequest var1);
    }
}

