/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CalculateLoyaltyPointsResponse {
    private final Optional<List<Error>> errors;
    private final Optional<Integer> points;
    private final Optional<Integer> promotionPoints;
    private final Map<String, Object> additionalProperties;

    private CalculateLoyaltyPointsResponse(Optional<List<Error>> errors, Optional<Integer> points, Optional<Integer> promotionPoints, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.points = points;
        this.promotionPoints = promotionPoints;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="points")
    public Optional<Integer> getPoints() {
        return this.points;
    }

    @JsonProperty(value="promotion_points")
    public Optional<Integer> getPromotionPoints() {
        return this.promotionPoints;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CalculateLoyaltyPointsResponse && this.equalTo((CalculateLoyaltyPointsResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CalculateLoyaltyPointsResponse other) {
        return this.errors.equals(other.errors) && this.points.equals(other.points) && this.promotionPoints.equals(other.promotionPoints);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.points, this.promotionPoints);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<Integer> points = Optional.empty();
        private Optional<Integer> promotionPoints = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CalculateLoyaltyPointsResponse other) {
            this.errors(other.getErrors());
            this.points(other.getPoints());
            this.promotionPoints(other.getPromotionPoints());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="points", nulls=Nulls.SKIP)
        public Builder points(Optional<Integer> points) {
            this.points = points;
            return this;
        }

        public Builder points(Integer points) {
            this.points = Optional.ofNullable(points);
            return this;
        }

        @JsonSetter(value="promotion_points", nulls=Nulls.SKIP)
        public Builder promotionPoints(Optional<Integer> promotionPoints) {
            this.promotionPoints = promotionPoints;
            return this;
        }

        public Builder promotionPoints(Integer promotionPoints) {
            this.promotionPoints = Optional.ofNullable(promotionPoints);
            return this;
        }

        public CalculateLoyaltyPointsResponse build() {
            return new CalculateLoyaltyPointsResponse(this.errors, this.points, this.promotionPoints, this.additionalProperties);
        }
    }
}

