/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Booking;
import com.squareup.square.types.Error;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CancelBookingResponse {
    private final Optional<Booking> booking;
    private final Optional<List<Error>> errors;
    private final Map<String, Object> additionalProperties;

    private CancelBookingResponse(Optional<Booking> booking, Optional<List<Error>> errors, Map<String, Object> additionalProperties) {
        this.booking = booking;
        this.errors = errors;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="booking")
    public Optional<Booking> getBooking() {
        return this.booking;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CancelBookingResponse && this.equalTo((CancelBookingResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CancelBookingResponse other) {
        return this.booking.equals(other.booking) && this.errors.equals(other.errors);
    }

    public int hashCode() {
        return Objects.hash(this.booking, this.errors);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Booking> booking = Optional.empty();
        private Optional<List<Error>> errors = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CancelBookingResponse other) {
            this.booking(other.getBooking());
            this.errors(other.getErrors());
            return this;
        }

        @JsonSetter(value="booking", nulls=Nulls.SKIP)
        public Builder booking(Optional<Booking> booking) {
            this.booking = booking;
            return this;
        }

        public Builder booking(Booking booking) {
            this.booking = Optional.ofNullable(booking);
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        public CancelBookingResponse build() {
            return new CancelBookingResponse(this.booking, this.errors, this.additionalProperties);
        }
    }
}

