/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Address;
import com.squareup.square.types.CardBrand;
import com.squareup.square.types.CardCoBrand;
import com.squareup.square.types.CardPrepaidType;
import com.squareup.square.types.CardType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Card {
    private final Optional<String> id;
    private final Optional<CardBrand> cardBrand;
    private final Optional<String> last4;
    private final Optional<Long> expMonth;
    private final Optional<Long> expYear;
    private final Optional<String> cardholderName;
    private final Optional<Address> billingAddress;
    private final Optional<String> fingerprint;
    private final Optional<String> customerId;
    private final Optional<String> merchantId;
    private final Optional<String> referenceId;
    private final Optional<Boolean> enabled;
    private final Optional<CardType> cardType;
    private final Optional<CardPrepaidType> prepaidType;
    private final Optional<String> bin;
    private final Optional<Long> version;
    private final Optional<CardCoBrand> cardCoBrand;
    private final Optional<String> issuerAlert;
    private final Optional<String> issuerAlertAt;
    private final Optional<Boolean> hsaFsa;
    private final Map<String, Object> additionalProperties;

    private Card(Optional<String> id, Optional<CardBrand> cardBrand, Optional<String> last4, Optional<Long> expMonth, Optional<Long> expYear, Optional<String> cardholderName, Optional<Address> billingAddress, Optional<String> fingerprint, Optional<String> customerId, Optional<String> merchantId, Optional<String> referenceId, Optional<Boolean> enabled, Optional<CardType> cardType, Optional<CardPrepaidType> prepaidType, Optional<String> bin, Optional<Long> version, Optional<CardCoBrand> cardCoBrand, Optional<String> issuerAlert, Optional<String> issuerAlertAt, Optional<Boolean> hsaFsa, Map<String, Object> additionalProperties) {
        this.id = id;
        this.cardBrand = cardBrand;
        this.last4 = last4;
        this.expMonth = expMonth;
        this.expYear = expYear;
        this.cardholderName = cardholderName;
        this.billingAddress = billingAddress;
        this.fingerprint = fingerprint;
        this.customerId = customerId;
        this.merchantId = merchantId;
        this.referenceId = referenceId;
        this.enabled = enabled;
        this.cardType = cardType;
        this.prepaidType = prepaidType;
        this.bin = bin;
        this.version = version;
        this.cardCoBrand = cardCoBrand;
        this.issuerAlert = issuerAlert;
        this.issuerAlertAt = issuerAlertAt;
        this.hsaFsa = hsaFsa;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="card_brand")
    public Optional<CardBrand> getCardBrand() {
        return this.cardBrand;
    }

    @JsonProperty(value="last_4")
    public Optional<String> getLast4() {
        return this.last4;
    }

    @JsonIgnore
    public Optional<Long> getExpMonth() {
        if (this.expMonth == null) {
            return Optional.empty();
        }
        return this.expMonth;
    }

    @JsonIgnore
    public Optional<Long> getExpYear() {
        if (this.expYear == null) {
            return Optional.empty();
        }
        return this.expYear;
    }

    @JsonIgnore
    public Optional<String> getCardholderName() {
        if (this.cardholderName == null) {
            return Optional.empty();
        }
        return this.cardholderName;
    }

    @JsonProperty(value="billing_address")
    public Optional<Address> getBillingAddress() {
        return this.billingAddress;
    }

    @JsonProperty(value="fingerprint")
    public Optional<String> getFingerprint() {
        return this.fingerprint;
    }

    @JsonIgnore
    public Optional<String> getCustomerId() {
        if (this.customerId == null) {
            return Optional.empty();
        }
        return this.customerId;
    }

    @JsonProperty(value="merchant_id")
    public Optional<String> getMerchantId() {
        return this.merchantId;
    }

    @JsonIgnore
    public Optional<String> getReferenceId() {
        if (this.referenceId == null) {
            return Optional.empty();
        }
        return this.referenceId;
    }

    @JsonProperty(value="enabled")
    public Optional<Boolean> getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="card_type")
    public Optional<CardType> getCardType() {
        return this.cardType;
    }

    @JsonProperty(value="prepaid_type")
    public Optional<CardPrepaidType> getPrepaidType() {
        return this.prepaidType;
    }

    @JsonProperty(value="bin")
    public Optional<String> getBin() {
        return this.bin;
    }

    @JsonProperty(value="version")
    public Optional<Long> getVersion() {
        return this.version;
    }

    @JsonProperty(value="card_co_brand")
    public Optional<CardCoBrand> getCardCoBrand() {
        return this.cardCoBrand;
    }

    @JsonProperty(value="issuer_alert")
    public Optional<String> getIssuerAlert() {
        return this.issuerAlert;
    }

    @JsonProperty(value="issuer_alert_at")
    public Optional<String> getIssuerAlertAt() {
        return this.issuerAlertAt;
    }

    @JsonProperty(value="hsa_fsa")
    public Optional<Boolean> getHsaFsa() {
        return this.hsaFsa;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="exp_month")
    private Optional<Long> _getExpMonth() {
        return this.expMonth;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="exp_year")
    private Optional<Long> _getExpYear() {
        return this.expYear;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="cardholder_name")
    private Optional<String> _getCardholderName() {
        return this.cardholderName;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="customer_id")
    private Optional<String> _getCustomerId() {
        return this.customerId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="reference_id")
    private Optional<String> _getReferenceId() {
        return this.referenceId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Card && this.equalTo((Card)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Card other) {
        return this.id.equals(other.id) && this.cardBrand.equals(other.cardBrand) && this.last4.equals(other.last4) && this.expMonth.equals(other.expMonth) && this.expYear.equals(other.expYear) && this.cardholderName.equals(other.cardholderName) && this.billingAddress.equals(other.billingAddress) && this.fingerprint.equals(other.fingerprint) && this.customerId.equals(other.customerId) && this.merchantId.equals(other.merchantId) && this.referenceId.equals(other.referenceId) && this.enabled.equals(other.enabled) && this.cardType.equals(other.cardType) && this.prepaidType.equals(other.prepaidType) && this.bin.equals(other.bin) && this.version.equals(other.version) && this.cardCoBrand.equals(other.cardCoBrand) && this.issuerAlert.equals(other.issuerAlert) && this.issuerAlertAt.equals(other.issuerAlertAt) && this.hsaFsa.equals(other.hsaFsa);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.cardBrand, this.last4, this.expMonth, this.expYear, this.cardholderName, this.billingAddress, this.fingerprint, this.customerId, this.merchantId, this.referenceId, this.enabled, this.cardType, this.prepaidType, this.bin, this.version, this.cardCoBrand, this.issuerAlert, this.issuerAlertAt, this.hsaFsa);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<CardBrand> cardBrand = Optional.empty();
        private Optional<String> last4 = Optional.empty();
        private Optional<Long> expMonth = Optional.empty();
        private Optional<Long> expYear = Optional.empty();
        private Optional<String> cardholderName = Optional.empty();
        private Optional<Address> billingAddress = Optional.empty();
        private Optional<String> fingerprint = Optional.empty();
        private Optional<String> customerId = Optional.empty();
        private Optional<String> merchantId = Optional.empty();
        private Optional<String> referenceId = Optional.empty();
        private Optional<Boolean> enabled = Optional.empty();
        private Optional<CardType> cardType = Optional.empty();
        private Optional<CardPrepaidType> prepaidType = Optional.empty();
        private Optional<String> bin = Optional.empty();
        private Optional<Long> version = Optional.empty();
        private Optional<CardCoBrand> cardCoBrand = Optional.empty();
        private Optional<String> issuerAlert = Optional.empty();
        private Optional<String> issuerAlertAt = Optional.empty();
        private Optional<Boolean> hsaFsa = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Card other) {
            this.id(other.getId());
            this.cardBrand(other.getCardBrand());
            this.last4(other.getLast4());
            this.expMonth(other.getExpMonth());
            this.expYear(other.getExpYear());
            this.cardholderName(other.getCardholderName());
            this.billingAddress(other.getBillingAddress());
            this.fingerprint(other.getFingerprint());
            this.customerId(other.getCustomerId());
            this.merchantId(other.getMerchantId());
            this.referenceId(other.getReferenceId());
            this.enabled(other.getEnabled());
            this.cardType(other.getCardType());
            this.prepaidType(other.getPrepaidType());
            this.bin(other.getBin());
            this.version(other.getVersion());
            this.cardCoBrand(other.getCardCoBrand());
            this.issuerAlert(other.getIssuerAlert());
            this.issuerAlertAt(other.getIssuerAlertAt());
            this.hsaFsa(other.getHsaFsa());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="card_brand", nulls=Nulls.SKIP)
        public Builder cardBrand(Optional<CardBrand> cardBrand) {
            this.cardBrand = cardBrand;
            return this;
        }

        public Builder cardBrand(CardBrand cardBrand) {
            this.cardBrand = Optional.ofNullable(cardBrand);
            return this;
        }

        @JsonSetter(value="last_4", nulls=Nulls.SKIP)
        public Builder last4(Optional<String> last4) {
            this.last4 = last4;
            return this;
        }

        public Builder last4(String last4) {
            this.last4 = Optional.ofNullable(last4);
            return this;
        }

        @JsonSetter(value="exp_month", nulls=Nulls.SKIP)
        public Builder expMonth(Optional<Long> expMonth) {
            this.expMonth = expMonth;
            return this;
        }

        public Builder expMonth(Long expMonth) {
            this.expMonth = Optional.ofNullable(expMonth);
            return this;
        }

        public Builder expMonth(Nullable<Long> expMonth) {
            this.expMonth = expMonth.isNull() ? null : (expMonth.isEmpty() ? Optional.empty() : Optional.of(expMonth.get()));
            return this;
        }

        @JsonSetter(value="exp_year", nulls=Nulls.SKIP)
        public Builder expYear(Optional<Long> expYear) {
            this.expYear = expYear;
            return this;
        }

        public Builder expYear(Long expYear) {
            this.expYear = Optional.ofNullable(expYear);
            return this;
        }

        public Builder expYear(Nullable<Long> expYear) {
            this.expYear = expYear.isNull() ? null : (expYear.isEmpty() ? Optional.empty() : Optional.of(expYear.get()));
            return this;
        }

        @JsonSetter(value="cardholder_name", nulls=Nulls.SKIP)
        public Builder cardholderName(Optional<String> cardholderName) {
            this.cardholderName = cardholderName;
            return this;
        }

        public Builder cardholderName(String cardholderName) {
            this.cardholderName = Optional.ofNullable(cardholderName);
            return this;
        }

        public Builder cardholderName(Nullable<String> cardholderName) {
            this.cardholderName = cardholderName.isNull() ? null : (cardholderName.isEmpty() ? Optional.empty() : Optional.of(cardholderName.get()));
            return this;
        }

        @JsonSetter(value="billing_address", nulls=Nulls.SKIP)
        public Builder billingAddress(Optional<Address> billingAddress) {
            this.billingAddress = billingAddress;
            return this;
        }

        public Builder billingAddress(Address billingAddress) {
            this.billingAddress = Optional.ofNullable(billingAddress);
            return this;
        }

        @JsonSetter(value="fingerprint", nulls=Nulls.SKIP)
        public Builder fingerprint(Optional<String> fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public Builder fingerprint(String fingerprint) {
            this.fingerprint = Optional.ofNullable(fingerprint);
            return this;
        }

        @JsonSetter(value="customer_id", nulls=Nulls.SKIP)
        public Builder customerId(Optional<String> customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder customerId(String customerId) {
            this.customerId = Optional.ofNullable(customerId);
            return this;
        }

        public Builder customerId(Nullable<String> customerId) {
            this.customerId = customerId.isNull() ? null : (customerId.isEmpty() ? Optional.empty() : Optional.of(customerId.get()));
            return this;
        }

        @JsonSetter(value="merchant_id", nulls=Nulls.SKIP)
        public Builder merchantId(Optional<String> merchantId) {
            this.merchantId = merchantId;
            return this;
        }

        public Builder merchantId(String merchantId) {
            this.merchantId = Optional.ofNullable(merchantId);
            return this;
        }

        @JsonSetter(value="reference_id", nulls=Nulls.SKIP)
        public Builder referenceId(Optional<String> referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public Builder referenceId(String referenceId) {
            this.referenceId = Optional.ofNullable(referenceId);
            return this;
        }

        public Builder referenceId(Nullable<String> referenceId) {
            this.referenceId = referenceId.isNull() ? null : (referenceId.isEmpty() ? Optional.empty() : Optional.of(referenceId.get()));
            return this;
        }

        @JsonSetter(value="enabled", nulls=Nulls.SKIP)
        public Builder enabled(Optional<Boolean> enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.enabled = Optional.ofNullable(enabled);
            return this;
        }

        @JsonSetter(value="card_type", nulls=Nulls.SKIP)
        public Builder cardType(Optional<CardType> cardType) {
            this.cardType = cardType;
            return this;
        }

        public Builder cardType(CardType cardType) {
            this.cardType = Optional.ofNullable(cardType);
            return this;
        }

        @JsonSetter(value="prepaid_type", nulls=Nulls.SKIP)
        public Builder prepaidType(Optional<CardPrepaidType> prepaidType) {
            this.prepaidType = prepaidType;
            return this;
        }

        public Builder prepaidType(CardPrepaidType prepaidType) {
            this.prepaidType = Optional.ofNullable(prepaidType);
            return this;
        }

        @JsonSetter(value="bin", nulls=Nulls.SKIP)
        public Builder bin(Optional<String> bin) {
            this.bin = bin;
            return this;
        }

        public Builder bin(String bin) {
            this.bin = Optional.ofNullable(bin);
            return this;
        }

        @JsonSetter(value="version", nulls=Nulls.SKIP)
        public Builder version(Optional<Long> version) {
            this.version = version;
            return this;
        }

        public Builder version(Long version) {
            this.version = Optional.ofNullable(version);
            return this;
        }

        @JsonSetter(value="card_co_brand", nulls=Nulls.SKIP)
        public Builder cardCoBrand(Optional<CardCoBrand> cardCoBrand) {
            this.cardCoBrand = cardCoBrand;
            return this;
        }

        public Builder cardCoBrand(CardCoBrand cardCoBrand) {
            this.cardCoBrand = Optional.ofNullable(cardCoBrand);
            return this;
        }

        @JsonSetter(value="issuer_alert", nulls=Nulls.SKIP)
        public Builder issuerAlert(Optional<String> issuerAlert) {
            this.issuerAlert = issuerAlert;
            return this;
        }

        public Builder issuerAlert(String issuerAlert) {
            this.issuerAlert = Optional.ofNullable(issuerAlert);
            return this;
        }

        @JsonSetter(value="issuer_alert_at", nulls=Nulls.SKIP)
        public Builder issuerAlertAt(Optional<String> issuerAlertAt) {
            this.issuerAlertAt = issuerAlertAt;
            return this;
        }

        public Builder issuerAlertAt(String issuerAlertAt) {
            this.issuerAlertAt = Optional.ofNullable(issuerAlertAt);
            return this;
        }

        @JsonSetter(value="hsa_fsa", nulls=Nulls.SKIP)
        public Builder hsaFsa(Optional<Boolean> hsaFsa) {
            this.hsaFsa = hsaFsa;
            return this;
        }

        public Builder hsaFsa(Boolean hsaFsa) {
            this.hsaFsa = Optional.ofNullable(hsaFsa);
            return this;
        }

        public Card build() {
            return new Card(this.id, this.cardBrand, this.last4, this.expMonth, this.expYear, this.cardholderName, this.billingAddress, this.fingerprint, this.customerId, this.merchantId, this.referenceId, this.enabled, this.cardType, this.prepaidType, this.bin, this.version, this.cardCoBrand, this.issuerAlert, this.issuerAlertAt, this.hsaFsa, this.additionalProperties);
        }
    }
}

