/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class CardCoBrand {
    public static final CardCoBrand AFTERPAY = new CardCoBrand(Value.AFTERPAY, "AFTERPAY");
    public static final CardCoBrand CLEARPAY = new CardCoBrand(Value.CLEARPAY, "CLEARPAY");
    public static final CardCoBrand UNKNOWN = new CardCoBrand(Value.UNKNOWN, "UNKNOWN");
    private final Value value;
    private final String string;

    CardCoBrand(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof CardCoBrand && this.string.equals(((CardCoBrand)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case AFTERPAY: {
                return visitor.visitAfterpay();
            }
            case CLEARPAY: {
                return visitor.visitClearpay();
            }
            case UNKNOWN: {
                return visitor.visitUnknown();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static CardCoBrand valueOf(String value) {
        switch (value) {
            case "AFTERPAY": {
                return AFTERPAY;
            }
            case "CLEARPAY": {
                return CLEARPAY;
            }
            case "UNKNOWN": {
                return UNKNOWN;
            }
        }
        return new CardCoBrand(Value._UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitUnknown();

        public T visitAfterpay();

        public T visitClearpay();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        UNKNOWN,
        AFTERPAY,
        CLEARPAY,
        _UNKNOWN;

    }
}

