/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CardForgottenEventCard {
    private final Optional<String> id;
    private final Optional<String> customerId;
    private final Optional<Boolean> enabled;
    private final Optional<String> referenceId;
    private final Optional<Long> version;
    private final Optional<String> merchantId;
    private final Map<String, Object> additionalProperties;

    private CardForgottenEventCard(Optional<String> id, Optional<String> customerId, Optional<Boolean> enabled, Optional<String> referenceId, Optional<Long> version, Optional<String> merchantId, Map<String, Object> additionalProperties) {
        this.id = id;
        this.customerId = customerId;
        this.enabled = enabled;
        this.referenceId = referenceId;
        this.version = version;
        this.merchantId = merchantId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonIgnore
    public Optional<String> getCustomerId() {
        if (this.customerId == null) {
            return Optional.empty();
        }
        return this.customerId;
    }

    @JsonIgnore
    public Optional<Boolean> getEnabled() {
        if (this.enabled == null) {
            return Optional.empty();
        }
        return this.enabled;
    }

    @JsonIgnore
    public Optional<String> getReferenceId() {
        if (this.referenceId == null) {
            return Optional.empty();
        }
        return this.referenceId;
    }

    @JsonProperty(value="version")
    public Optional<Long> getVersion() {
        return this.version;
    }

    @JsonIgnore
    public Optional<String> getMerchantId() {
        if (this.merchantId == null) {
            return Optional.empty();
        }
        return this.merchantId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="customer_id")
    private Optional<String> _getCustomerId() {
        return this.customerId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="enabled")
    private Optional<Boolean> _getEnabled() {
        return this.enabled;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="reference_id")
    private Optional<String> _getReferenceId() {
        return this.referenceId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="merchant_id")
    private Optional<String> _getMerchantId() {
        return this.merchantId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CardForgottenEventCard && this.equalTo((CardForgottenEventCard)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CardForgottenEventCard other) {
        return this.id.equals(other.id) && this.customerId.equals(other.customerId) && this.enabled.equals(other.enabled) && this.referenceId.equals(other.referenceId) && this.version.equals(other.version) && this.merchantId.equals(other.merchantId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.customerId, this.enabled, this.referenceId, this.version, this.merchantId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> customerId = Optional.empty();
        private Optional<Boolean> enabled = Optional.empty();
        private Optional<String> referenceId = Optional.empty();
        private Optional<Long> version = Optional.empty();
        private Optional<String> merchantId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CardForgottenEventCard other) {
            this.id(other.getId());
            this.customerId(other.getCustomerId());
            this.enabled(other.getEnabled());
            this.referenceId(other.getReferenceId());
            this.version(other.getVersion());
            this.merchantId(other.getMerchantId());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="customer_id", nulls=Nulls.SKIP)
        public Builder customerId(Optional<String> customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder customerId(String customerId) {
            this.customerId = Optional.ofNullable(customerId);
            return this;
        }

        public Builder customerId(Nullable<String> customerId) {
            this.customerId = customerId.isNull() ? null : (customerId.isEmpty() ? Optional.empty() : Optional.of(customerId.get()));
            return this;
        }

        @JsonSetter(value="enabled", nulls=Nulls.SKIP)
        public Builder enabled(Optional<Boolean> enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.enabled = Optional.ofNullable(enabled);
            return this;
        }

        public Builder enabled(Nullable<Boolean> enabled) {
            this.enabled = enabled.isNull() ? null : (enabled.isEmpty() ? Optional.empty() : Optional.of(enabled.get()));
            return this;
        }

        @JsonSetter(value="reference_id", nulls=Nulls.SKIP)
        public Builder referenceId(Optional<String> referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public Builder referenceId(String referenceId) {
            this.referenceId = Optional.ofNullable(referenceId);
            return this;
        }

        public Builder referenceId(Nullable<String> referenceId) {
            this.referenceId = referenceId.isNull() ? null : (referenceId.isEmpty() ? Optional.empty() : Optional.of(referenceId.get()));
            return this;
        }

        @JsonSetter(value="version", nulls=Nulls.SKIP)
        public Builder version(Optional<Long> version) {
            this.version = version;
            return this;
        }

        public Builder version(Long version) {
            this.version = Optional.ofNullable(version);
            return this;
        }

        @JsonSetter(value="merchant_id", nulls=Nulls.SKIP)
        public Builder merchantId(Optional<String> merchantId) {
            this.merchantId = merchantId;
            return this;
        }

        public Builder merchantId(String merchantId) {
            this.merchantId = Optional.ofNullable(merchantId);
            return this;
        }

        public Builder merchantId(Nullable<String> merchantId) {
            this.merchantId = merchantId.isNull() ? null : (merchantId.isEmpty() ? Optional.empty() : Optional.of(merchantId.get()));
            return this;
        }

        public CardForgottenEventCard build() {
            return new CardForgottenEventCard(this.id, this.customerId, this.enabled, this.referenceId, this.version, this.merchantId, this.additionalProperties);
        }
    }
}

