/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Card;
import com.squareup.square.types.CardPaymentTimeline;
import com.squareup.square.types.DeviceDetails;
import com.squareup.square.types.Error;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CardPaymentDetails {
    private final Optional<String> status;
    private final Optional<Card> card;
    private final Optional<String> entryMethod;
    private final Optional<String> cvvStatus;
    private final Optional<String> avsStatus;
    private final Optional<String> authResultCode;
    private final Optional<String> applicationIdentifier;
    private final Optional<String> applicationName;
    private final Optional<String> applicationCryptogram;
    private final Optional<String> verificationMethod;
    private final Optional<String> verificationResults;
    private final Optional<String> statementDescription;
    private final Optional<DeviceDetails> deviceDetails;
    private final Optional<CardPaymentTimeline> cardPaymentTimeline;
    private final Optional<Boolean> refundRequiresCardPresence;
    private final Optional<List<Error>> errors;
    private final Map<String, Object> additionalProperties;

    private CardPaymentDetails(Optional<String> status, Optional<Card> card, Optional<String> entryMethod, Optional<String> cvvStatus, Optional<String> avsStatus, Optional<String> authResultCode, Optional<String> applicationIdentifier, Optional<String> applicationName, Optional<String> applicationCryptogram, Optional<String> verificationMethod, Optional<String> verificationResults, Optional<String> statementDescription, Optional<DeviceDetails> deviceDetails, Optional<CardPaymentTimeline> cardPaymentTimeline, Optional<Boolean> refundRequiresCardPresence, Optional<List<Error>> errors, Map<String, Object> additionalProperties) {
        this.status = status;
        this.card = card;
        this.entryMethod = entryMethod;
        this.cvvStatus = cvvStatus;
        this.avsStatus = avsStatus;
        this.authResultCode = authResultCode;
        this.applicationIdentifier = applicationIdentifier;
        this.applicationName = applicationName;
        this.applicationCryptogram = applicationCryptogram;
        this.verificationMethod = verificationMethod;
        this.verificationResults = verificationResults;
        this.statementDescription = statementDescription;
        this.deviceDetails = deviceDetails;
        this.cardPaymentTimeline = cardPaymentTimeline;
        this.refundRequiresCardPresence = refundRequiresCardPresence;
        this.errors = errors;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getStatus() {
        if (this.status == null) {
            return Optional.empty();
        }
        return this.status;
    }

    @JsonProperty(value="card")
    public Optional<Card> getCard() {
        return this.card;
    }

    @JsonIgnore
    public Optional<String> getEntryMethod() {
        if (this.entryMethod == null) {
            return Optional.empty();
        }
        return this.entryMethod;
    }

    @JsonIgnore
    public Optional<String> getCvvStatus() {
        if (this.cvvStatus == null) {
            return Optional.empty();
        }
        return this.cvvStatus;
    }

    @JsonIgnore
    public Optional<String> getAvsStatus() {
        if (this.avsStatus == null) {
            return Optional.empty();
        }
        return this.avsStatus;
    }

    @JsonIgnore
    public Optional<String> getAuthResultCode() {
        if (this.authResultCode == null) {
            return Optional.empty();
        }
        return this.authResultCode;
    }

    @JsonIgnore
    public Optional<String> getApplicationIdentifier() {
        if (this.applicationIdentifier == null) {
            return Optional.empty();
        }
        return this.applicationIdentifier;
    }

    @JsonIgnore
    public Optional<String> getApplicationName() {
        if (this.applicationName == null) {
            return Optional.empty();
        }
        return this.applicationName;
    }

    @JsonIgnore
    public Optional<String> getApplicationCryptogram() {
        if (this.applicationCryptogram == null) {
            return Optional.empty();
        }
        return this.applicationCryptogram;
    }

    @JsonIgnore
    public Optional<String> getVerificationMethod() {
        if (this.verificationMethod == null) {
            return Optional.empty();
        }
        return this.verificationMethod;
    }

    @JsonIgnore
    public Optional<String> getVerificationResults() {
        if (this.verificationResults == null) {
            return Optional.empty();
        }
        return this.verificationResults;
    }

    @JsonIgnore
    public Optional<String> getStatementDescription() {
        if (this.statementDescription == null) {
            return Optional.empty();
        }
        return this.statementDescription;
    }

    @JsonProperty(value="device_details")
    public Optional<DeviceDetails> getDeviceDetails() {
        return this.deviceDetails;
    }

    @JsonProperty(value="card_payment_timeline")
    public Optional<CardPaymentTimeline> getCardPaymentTimeline() {
        return this.cardPaymentTimeline;
    }

    @JsonIgnore
    public Optional<Boolean> getRefundRequiresCardPresence() {
        if (this.refundRequiresCardPresence == null) {
            return Optional.empty();
        }
        return this.refundRequiresCardPresence;
    }

    @JsonIgnore
    public Optional<List<Error>> getErrors() {
        if (this.errors == null) {
            return Optional.empty();
        }
        return this.errors;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="status")
    private Optional<String> _getStatus() {
        return this.status;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="entry_method")
    private Optional<String> _getEntryMethod() {
        return this.entryMethod;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="cvv_status")
    private Optional<String> _getCvvStatus() {
        return this.cvvStatus;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="avs_status")
    private Optional<String> _getAvsStatus() {
        return this.avsStatus;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="auth_result_code")
    private Optional<String> _getAuthResultCode() {
        return this.authResultCode;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="application_identifier")
    private Optional<String> _getApplicationIdentifier() {
        return this.applicationIdentifier;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="application_name")
    private Optional<String> _getApplicationName() {
        return this.applicationName;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="application_cryptogram")
    private Optional<String> _getApplicationCryptogram() {
        return this.applicationCryptogram;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="verification_method")
    private Optional<String> _getVerificationMethod() {
        return this.verificationMethod;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="verification_results")
    private Optional<String> _getVerificationResults() {
        return this.verificationResults;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="statement_description")
    private Optional<String> _getStatementDescription() {
        return this.statementDescription;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="refund_requires_card_presence")
    private Optional<Boolean> _getRefundRequiresCardPresence() {
        return this.refundRequiresCardPresence;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="errors")
    private Optional<List<Error>> _getErrors() {
        return this.errors;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CardPaymentDetails && this.equalTo((CardPaymentDetails)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CardPaymentDetails other) {
        return this.status.equals(other.status) && this.card.equals(other.card) && this.entryMethod.equals(other.entryMethod) && this.cvvStatus.equals(other.cvvStatus) && this.avsStatus.equals(other.avsStatus) && this.authResultCode.equals(other.authResultCode) && this.applicationIdentifier.equals(other.applicationIdentifier) && this.applicationName.equals(other.applicationName) && this.applicationCryptogram.equals(other.applicationCryptogram) && this.verificationMethod.equals(other.verificationMethod) && this.verificationResults.equals(other.verificationResults) && this.statementDescription.equals(other.statementDescription) && this.deviceDetails.equals(other.deviceDetails) && this.cardPaymentTimeline.equals(other.cardPaymentTimeline) && this.refundRequiresCardPresence.equals(other.refundRequiresCardPresence) && this.errors.equals(other.errors);
    }

    public int hashCode() {
        return Objects.hash(this.status, this.card, this.entryMethod, this.cvvStatus, this.avsStatus, this.authResultCode, this.applicationIdentifier, this.applicationName, this.applicationCryptogram, this.verificationMethod, this.verificationResults, this.statementDescription, this.deviceDetails, this.cardPaymentTimeline, this.refundRequiresCardPresence, this.errors);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> status = Optional.empty();
        private Optional<Card> card = Optional.empty();
        private Optional<String> entryMethod = Optional.empty();
        private Optional<String> cvvStatus = Optional.empty();
        private Optional<String> avsStatus = Optional.empty();
        private Optional<String> authResultCode = Optional.empty();
        private Optional<String> applicationIdentifier = Optional.empty();
        private Optional<String> applicationName = Optional.empty();
        private Optional<String> applicationCryptogram = Optional.empty();
        private Optional<String> verificationMethod = Optional.empty();
        private Optional<String> verificationResults = Optional.empty();
        private Optional<String> statementDescription = Optional.empty();
        private Optional<DeviceDetails> deviceDetails = Optional.empty();
        private Optional<CardPaymentTimeline> cardPaymentTimeline = Optional.empty();
        private Optional<Boolean> refundRequiresCardPresence = Optional.empty();
        private Optional<List<Error>> errors = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CardPaymentDetails other) {
            this.status(other.getStatus());
            this.card(other.getCard());
            this.entryMethod(other.getEntryMethod());
            this.cvvStatus(other.getCvvStatus());
            this.avsStatus(other.getAvsStatus());
            this.authResultCode(other.getAuthResultCode());
            this.applicationIdentifier(other.getApplicationIdentifier());
            this.applicationName(other.getApplicationName());
            this.applicationCryptogram(other.getApplicationCryptogram());
            this.verificationMethod(other.getVerificationMethod());
            this.verificationResults(other.getVerificationResults());
            this.statementDescription(other.getStatementDescription());
            this.deviceDetails(other.getDeviceDetails());
            this.cardPaymentTimeline(other.getCardPaymentTimeline());
            this.refundRequiresCardPresence(other.getRefundRequiresCardPresence());
            this.errors(other.getErrors());
            return this;
        }

        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public Builder status(Optional<String> status) {
            this.status = status;
            return this;
        }

        public Builder status(String status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        public Builder status(Nullable<String> status) {
            this.status = status.isNull() ? null : (status.isEmpty() ? Optional.empty() : Optional.of(status.get()));
            return this;
        }

        @JsonSetter(value="card", nulls=Nulls.SKIP)
        public Builder card(Optional<Card> card) {
            this.card = card;
            return this;
        }

        public Builder card(Card card) {
            this.card = Optional.ofNullable(card);
            return this;
        }

        @JsonSetter(value="entry_method", nulls=Nulls.SKIP)
        public Builder entryMethod(Optional<String> entryMethod) {
            this.entryMethod = entryMethod;
            return this;
        }

        public Builder entryMethod(String entryMethod) {
            this.entryMethod = Optional.ofNullable(entryMethod);
            return this;
        }

        public Builder entryMethod(Nullable<String> entryMethod) {
            this.entryMethod = entryMethod.isNull() ? null : (entryMethod.isEmpty() ? Optional.empty() : Optional.of(entryMethod.get()));
            return this;
        }

        @JsonSetter(value="cvv_status", nulls=Nulls.SKIP)
        public Builder cvvStatus(Optional<String> cvvStatus) {
            this.cvvStatus = cvvStatus;
            return this;
        }

        public Builder cvvStatus(String cvvStatus) {
            this.cvvStatus = Optional.ofNullable(cvvStatus);
            return this;
        }

        public Builder cvvStatus(Nullable<String> cvvStatus) {
            this.cvvStatus = cvvStatus.isNull() ? null : (cvvStatus.isEmpty() ? Optional.empty() : Optional.of(cvvStatus.get()));
            return this;
        }

        @JsonSetter(value="avs_status", nulls=Nulls.SKIP)
        public Builder avsStatus(Optional<String> avsStatus) {
            this.avsStatus = avsStatus;
            return this;
        }

        public Builder avsStatus(String avsStatus) {
            this.avsStatus = Optional.ofNullable(avsStatus);
            return this;
        }

        public Builder avsStatus(Nullable<String> avsStatus) {
            this.avsStatus = avsStatus.isNull() ? null : (avsStatus.isEmpty() ? Optional.empty() : Optional.of(avsStatus.get()));
            return this;
        }

        @JsonSetter(value="auth_result_code", nulls=Nulls.SKIP)
        public Builder authResultCode(Optional<String> authResultCode) {
            this.authResultCode = authResultCode;
            return this;
        }

        public Builder authResultCode(String authResultCode) {
            this.authResultCode = Optional.ofNullable(authResultCode);
            return this;
        }

        public Builder authResultCode(Nullable<String> authResultCode) {
            this.authResultCode = authResultCode.isNull() ? null : (authResultCode.isEmpty() ? Optional.empty() : Optional.of(authResultCode.get()));
            return this;
        }

        @JsonSetter(value="application_identifier", nulls=Nulls.SKIP)
        public Builder applicationIdentifier(Optional<String> applicationIdentifier) {
            this.applicationIdentifier = applicationIdentifier;
            return this;
        }

        public Builder applicationIdentifier(String applicationIdentifier) {
            this.applicationIdentifier = Optional.ofNullable(applicationIdentifier);
            return this;
        }

        public Builder applicationIdentifier(Nullable<String> applicationIdentifier) {
            this.applicationIdentifier = applicationIdentifier.isNull() ? null : (applicationIdentifier.isEmpty() ? Optional.empty() : Optional.of(applicationIdentifier.get()));
            return this;
        }

        @JsonSetter(value="application_name", nulls=Nulls.SKIP)
        public Builder applicationName(Optional<String> applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public Builder applicationName(String applicationName) {
            this.applicationName = Optional.ofNullable(applicationName);
            return this;
        }

        public Builder applicationName(Nullable<String> applicationName) {
            this.applicationName = applicationName.isNull() ? null : (applicationName.isEmpty() ? Optional.empty() : Optional.of(applicationName.get()));
            return this;
        }

        @JsonSetter(value="application_cryptogram", nulls=Nulls.SKIP)
        public Builder applicationCryptogram(Optional<String> applicationCryptogram) {
            this.applicationCryptogram = applicationCryptogram;
            return this;
        }

        public Builder applicationCryptogram(String applicationCryptogram) {
            this.applicationCryptogram = Optional.ofNullable(applicationCryptogram);
            return this;
        }

        public Builder applicationCryptogram(Nullable<String> applicationCryptogram) {
            this.applicationCryptogram = applicationCryptogram.isNull() ? null : (applicationCryptogram.isEmpty() ? Optional.empty() : Optional.of(applicationCryptogram.get()));
            return this;
        }

        @JsonSetter(value="verification_method", nulls=Nulls.SKIP)
        public Builder verificationMethod(Optional<String> verificationMethod) {
            this.verificationMethod = verificationMethod;
            return this;
        }

        public Builder verificationMethod(String verificationMethod) {
            this.verificationMethod = Optional.ofNullable(verificationMethod);
            return this;
        }

        public Builder verificationMethod(Nullable<String> verificationMethod) {
            this.verificationMethod = verificationMethod.isNull() ? null : (verificationMethod.isEmpty() ? Optional.empty() : Optional.of(verificationMethod.get()));
            return this;
        }

        @JsonSetter(value="verification_results", nulls=Nulls.SKIP)
        public Builder verificationResults(Optional<String> verificationResults) {
            this.verificationResults = verificationResults;
            return this;
        }

        public Builder verificationResults(String verificationResults) {
            this.verificationResults = Optional.ofNullable(verificationResults);
            return this;
        }

        public Builder verificationResults(Nullable<String> verificationResults) {
            this.verificationResults = verificationResults.isNull() ? null : (verificationResults.isEmpty() ? Optional.empty() : Optional.of(verificationResults.get()));
            return this;
        }

        @JsonSetter(value="statement_description", nulls=Nulls.SKIP)
        public Builder statementDescription(Optional<String> statementDescription) {
            this.statementDescription = statementDescription;
            return this;
        }

        public Builder statementDescription(String statementDescription) {
            this.statementDescription = Optional.ofNullable(statementDescription);
            return this;
        }

        public Builder statementDescription(Nullable<String> statementDescription) {
            this.statementDescription = statementDescription.isNull() ? null : (statementDescription.isEmpty() ? Optional.empty() : Optional.of(statementDescription.get()));
            return this;
        }

        @JsonSetter(value="device_details", nulls=Nulls.SKIP)
        public Builder deviceDetails(Optional<DeviceDetails> deviceDetails) {
            this.deviceDetails = deviceDetails;
            return this;
        }

        public Builder deviceDetails(DeviceDetails deviceDetails) {
            this.deviceDetails = Optional.ofNullable(deviceDetails);
            return this;
        }

        @JsonSetter(value="card_payment_timeline", nulls=Nulls.SKIP)
        public Builder cardPaymentTimeline(Optional<CardPaymentTimeline> cardPaymentTimeline) {
            this.cardPaymentTimeline = cardPaymentTimeline;
            return this;
        }

        public Builder cardPaymentTimeline(CardPaymentTimeline cardPaymentTimeline) {
            this.cardPaymentTimeline = Optional.ofNullable(cardPaymentTimeline);
            return this;
        }

        @JsonSetter(value="refund_requires_card_presence", nulls=Nulls.SKIP)
        public Builder refundRequiresCardPresence(Optional<Boolean> refundRequiresCardPresence) {
            this.refundRequiresCardPresence = refundRequiresCardPresence;
            return this;
        }

        public Builder refundRequiresCardPresence(Boolean refundRequiresCardPresence) {
            this.refundRequiresCardPresence = Optional.ofNullable(refundRequiresCardPresence);
            return this;
        }

        public Builder refundRequiresCardPresence(Nullable<Boolean> refundRequiresCardPresence) {
            this.refundRequiresCardPresence = refundRequiresCardPresence.isNull() ? null : (refundRequiresCardPresence.isEmpty() ? Optional.empty() : Optional.of(refundRequiresCardPresence.get()));
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        public Builder errors(Nullable<List<Error>> errors) {
            this.errors = errors.isNull() ? null : (errors.isEmpty() ? Optional.empty() : Optional.of(errors.get()));
            return this;
        }

        public CardPaymentDetails build() {
            return new CardPaymentDetails(this.status, this.card, this.entryMethod, this.cvvStatus, this.avsStatus, this.authResultCode, this.applicationIdentifier, this.applicationName, this.applicationCryptogram, this.verificationMethod, this.verificationResults, this.statementDescription, this.deviceDetails, this.cardPaymentTimeline, this.refundRequiresCardPresence, this.errors, this.additionalProperties);
        }
    }
}

