/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CashDrawerDevice;
import com.squareup.square.types.CashDrawerShiftState;
import com.squareup.square.types.Money;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CashDrawerShift {
    private final Optional<String> id;
    private final Optional<CashDrawerShiftState> state;
    private final Optional<String> openedAt;
    private final Optional<String> endedAt;
    private final Optional<String> closedAt;
    private final Optional<String> description;
    private final Optional<Money> openedCashMoney;
    private final Optional<Money> cashPaymentMoney;
    private final Optional<Money> cashRefundsMoney;
    private final Optional<Money> cashPaidInMoney;
    private final Optional<Money> cashPaidOutMoney;
    private final Optional<Money> expectedCashMoney;
    private final Optional<Money> closedCashMoney;
    private final Optional<CashDrawerDevice> device;
    private final Optional<String> createdAt;
    private final Optional<String> updatedAt;
    private final Optional<String> locationId;
    private final Optional<List<String>> teamMemberIds;
    private final Optional<String> openingTeamMemberId;
    private final Optional<String> endingTeamMemberId;
    private final Optional<String> closingTeamMemberId;
    private final Map<String, Object> additionalProperties;

    private CashDrawerShift(Optional<String> id, Optional<CashDrawerShiftState> state, Optional<String> openedAt, Optional<String> endedAt, Optional<String> closedAt, Optional<String> description, Optional<Money> openedCashMoney, Optional<Money> cashPaymentMoney, Optional<Money> cashRefundsMoney, Optional<Money> cashPaidInMoney, Optional<Money> cashPaidOutMoney, Optional<Money> expectedCashMoney, Optional<Money> closedCashMoney, Optional<CashDrawerDevice> device, Optional<String> createdAt, Optional<String> updatedAt, Optional<String> locationId, Optional<List<String>> teamMemberIds, Optional<String> openingTeamMemberId, Optional<String> endingTeamMemberId, Optional<String> closingTeamMemberId, Map<String, Object> additionalProperties) {
        this.id = id;
        this.state = state;
        this.openedAt = openedAt;
        this.endedAt = endedAt;
        this.closedAt = closedAt;
        this.description = description;
        this.openedCashMoney = openedCashMoney;
        this.cashPaymentMoney = cashPaymentMoney;
        this.cashRefundsMoney = cashRefundsMoney;
        this.cashPaidInMoney = cashPaidInMoney;
        this.cashPaidOutMoney = cashPaidOutMoney;
        this.expectedCashMoney = expectedCashMoney;
        this.closedCashMoney = closedCashMoney;
        this.device = device;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.locationId = locationId;
        this.teamMemberIds = teamMemberIds;
        this.openingTeamMemberId = openingTeamMemberId;
        this.endingTeamMemberId = endingTeamMemberId;
        this.closingTeamMemberId = closingTeamMemberId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="state")
    public Optional<CashDrawerShiftState> getState() {
        return this.state;
    }

    @JsonIgnore
    public Optional<String> getOpenedAt() {
        if (this.openedAt == null) {
            return Optional.empty();
        }
        return this.openedAt;
    }

    @JsonIgnore
    public Optional<String> getEndedAt() {
        if (this.endedAt == null) {
            return Optional.empty();
        }
        return this.endedAt;
    }

    @JsonIgnore
    public Optional<String> getClosedAt() {
        if (this.closedAt == null) {
            return Optional.empty();
        }
        return this.closedAt;
    }

    @JsonIgnore
    public Optional<String> getDescription() {
        if (this.description == null) {
            return Optional.empty();
        }
        return this.description;
    }

    @JsonProperty(value="opened_cash_money")
    public Optional<Money> getOpenedCashMoney() {
        return this.openedCashMoney;
    }

    @JsonProperty(value="cash_payment_money")
    public Optional<Money> getCashPaymentMoney() {
        return this.cashPaymentMoney;
    }

    @JsonProperty(value="cash_refunds_money")
    public Optional<Money> getCashRefundsMoney() {
        return this.cashRefundsMoney;
    }

    @JsonProperty(value="cash_paid_in_money")
    public Optional<Money> getCashPaidInMoney() {
        return this.cashPaidInMoney;
    }

    @JsonProperty(value="cash_paid_out_money")
    public Optional<Money> getCashPaidOutMoney() {
        return this.cashPaidOutMoney;
    }

    @JsonProperty(value="expected_cash_money")
    public Optional<Money> getExpectedCashMoney() {
        return this.expectedCashMoney;
    }

    @JsonProperty(value="closed_cash_money")
    public Optional<Money> getClosedCashMoney() {
        return this.closedCashMoney;
    }

    @JsonProperty(value="device")
    public Optional<CashDrawerDevice> getDevice() {
        return this.device;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<String> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="location_id")
    public Optional<String> getLocationId() {
        return this.locationId;
    }

    @JsonProperty(value="team_member_ids")
    public Optional<List<String>> getTeamMemberIds() {
        return this.teamMemberIds;
    }

    @JsonProperty(value="opening_team_member_id")
    public Optional<String> getOpeningTeamMemberId() {
        return this.openingTeamMemberId;
    }

    @JsonProperty(value="ending_team_member_id")
    public Optional<String> getEndingTeamMemberId() {
        return this.endingTeamMemberId;
    }

    @JsonProperty(value="closing_team_member_id")
    public Optional<String> getClosingTeamMemberId() {
        return this.closingTeamMemberId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="opened_at")
    private Optional<String> _getOpenedAt() {
        return this.openedAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="ended_at")
    private Optional<String> _getEndedAt() {
        return this.endedAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="closed_at")
    private Optional<String> _getClosedAt() {
        return this.closedAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="description")
    private Optional<String> _getDescription() {
        return this.description;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CashDrawerShift && this.equalTo((CashDrawerShift)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CashDrawerShift other) {
        return this.id.equals(other.id) && this.state.equals(other.state) && this.openedAt.equals(other.openedAt) && this.endedAt.equals(other.endedAt) && this.closedAt.equals(other.closedAt) && this.description.equals(other.description) && this.openedCashMoney.equals(other.openedCashMoney) && this.cashPaymentMoney.equals(other.cashPaymentMoney) && this.cashRefundsMoney.equals(other.cashRefundsMoney) && this.cashPaidInMoney.equals(other.cashPaidInMoney) && this.cashPaidOutMoney.equals(other.cashPaidOutMoney) && this.expectedCashMoney.equals(other.expectedCashMoney) && this.closedCashMoney.equals(other.closedCashMoney) && this.device.equals(other.device) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.locationId.equals(other.locationId) && this.teamMemberIds.equals(other.teamMemberIds) && this.openingTeamMemberId.equals(other.openingTeamMemberId) && this.endingTeamMemberId.equals(other.endingTeamMemberId) && this.closingTeamMemberId.equals(other.closingTeamMemberId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.state, this.openedAt, this.endedAt, this.closedAt, this.description, this.openedCashMoney, this.cashPaymentMoney, this.cashRefundsMoney, this.cashPaidInMoney, this.cashPaidOutMoney, this.expectedCashMoney, this.closedCashMoney, this.device, this.createdAt, this.updatedAt, this.locationId, this.teamMemberIds, this.openingTeamMemberId, this.endingTeamMemberId, this.closingTeamMemberId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<CashDrawerShiftState> state = Optional.empty();
        private Optional<String> openedAt = Optional.empty();
        private Optional<String> endedAt = Optional.empty();
        private Optional<String> closedAt = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<Money> openedCashMoney = Optional.empty();
        private Optional<Money> cashPaymentMoney = Optional.empty();
        private Optional<Money> cashRefundsMoney = Optional.empty();
        private Optional<Money> cashPaidInMoney = Optional.empty();
        private Optional<Money> cashPaidOutMoney = Optional.empty();
        private Optional<Money> expectedCashMoney = Optional.empty();
        private Optional<Money> closedCashMoney = Optional.empty();
        private Optional<CashDrawerDevice> device = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<String> updatedAt = Optional.empty();
        private Optional<String> locationId = Optional.empty();
        private Optional<List<String>> teamMemberIds = Optional.empty();
        private Optional<String> openingTeamMemberId = Optional.empty();
        private Optional<String> endingTeamMemberId = Optional.empty();
        private Optional<String> closingTeamMemberId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CashDrawerShift other) {
            this.id(other.getId());
            this.state(other.getState());
            this.openedAt(other.getOpenedAt());
            this.endedAt(other.getEndedAt());
            this.closedAt(other.getClosedAt());
            this.description(other.getDescription());
            this.openedCashMoney(other.getOpenedCashMoney());
            this.cashPaymentMoney(other.getCashPaymentMoney());
            this.cashRefundsMoney(other.getCashRefundsMoney());
            this.cashPaidInMoney(other.getCashPaidInMoney());
            this.cashPaidOutMoney(other.getCashPaidOutMoney());
            this.expectedCashMoney(other.getExpectedCashMoney());
            this.closedCashMoney(other.getClosedCashMoney());
            this.device(other.getDevice());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.locationId(other.getLocationId());
            this.teamMemberIds(other.getTeamMemberIds());
            this.openingTeamMemberId(other.getOpeningTeamMemberId());
            this.endingTeamMemberId(other.getEndingTeamMemberId());
            this.closingTeamMemberId(other.getClosingTeamMemberId());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="state", nulls=Nulls.SKIP)
        public Builder state(Optional<CashDrawerShiftState> state) {
            this.state = state;
            return this;
        }

        public Builder state(CashDrawerShiftState state) {
            this.state = Optional.ofNullable(state);
            return this;
        }

        @JsonSetter(value="opened_at", nulls=Nulls.SKIP)
        public Builder openedAt(Optional<String> openedAt) {
            this.openedAt = openedAt;
            return this;
        }

        public Builder openedAt(String openedAt) {
            this.openedAt = Optional.ofNullable(openedAt);
            return this;
        }

        public Builder openedAt(Nullable<String> openedAt) {
            this.openedAt = openedAt.isNull() ? null : (openedAt.isEmpty() ? Optional.empty() : Optional.of(openedAt.get()));
            return this;
        }

        @JsonSetter(value="ended_at", nulls=Nulls.SKIP)
        public Builder endedAt(Optional<String> endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public Builder endedAt(String endedAt) {
            this.endedAt = Optional.ofNullable(endedAt);
            return this;
        }

        public Builder endedAt(Nullable<String> endedAt) {
            this.endedAt = endedAt.isNull() ? null : (endedAt.isEmpty() ? Optional.empty() : Optional.of(endedAt.get()));
            return this;
        }

        @JsonSetter(value="closed_at", nulls=Nulls.SKIP)
        public Builder closedAt(Optional<String> closedAt) {
            this.closedAt = closedAt;
            return this;
        }

        public Builder closedAt(String closedAt) {
            this.closedAt = Optional.ofNullable(closedAt);
            return this;
        }

        public Builder closedAt(Nullable<String> closedAt) {
            this.closedAt = closedAt.isNull() ? null : (closedAt.isEmpty() ? Optional.empty() : Optional.of(closedAt.get()));
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        public Builder description(Nullable<String> description) {
            this.description = description.isNull() ? null : (description.isEmpty() ? Optional.empty() : Optional.of(description.get()));
            return this;
        }

        @JsonSetter(value="opened_cash_money", nulls=Nulls.SKIP)
        public Builder openedCashMoney(Optional<Money> openedCashMoney) {
            this.openedCashMoney = openedCashMoney;
            return this;
        }

        public Builder openedCashMoney(Money openedCashMoney) {
            this.openedCashMoney = Optional.ofNullable(openedCashMoney);
            return this;
        }

        @JsonSetter(value="cash_payment_money", nulls=Nulls.SKIP)
        public Builder cashPaymentMoney(Optional<Money> cashPaymentMoney) {
            this.cashPaymentMoney = cashPaymentMoney;
            return this;
        }

        public Builder cashPaymentMoney(Money cashPaymentMoney) {
            this.cashPaymentMoney = Optional.ofNullable(cashPaymentMoney);
            return this;
        }

        @JsonSetter(value="cash_refunds_money", nulls=Nulls.SKIP)
        public Builder cashRefundsMoney(Optional<Money> cashRefundsMoney) {
            this.cashRefundsMoney = cashRefundsMoney;
            return this;
        }

        public Builder cashRefundsMoney(Money cashRefundsMoney) {
            this.cashRefundsMoney = Optional.ofNullable(cashRefundsMoney);
            return this;
        }

        @JsonSetter(value="cash_paid_in_money", nulls=Nulls.SKIP)
        public Builder cashPaidInMoney(Optional<Money> cashPaidInMoney) {
            this.cashPaidInMoney = cashPaidInMoney;
            return this;
        }

        public Builder cashPaidInMoney(Money cashPaidInMoney) {
            this.cashPaidInMoney = Optional.ofNullable(cashPaidInMoney);
            return this;
        }

        @JsonSetter(value="cash_paid_out_money", nulls=Nulls.SKIP)
        public Builder cashPaidOutMoney(Optional<Money> cashPaidOutMoney) {
            this.cashPaidOutMoney = cashPaidOutMoney;
            return this;
        }

        public Builder cashPaidOutMoney(Money cashPaidOutMoney) {
            this.cashPaidOutMoney = Optional.ofNullable(cashPaidOutMoney);
            return this;
        }

        @JsonSetter(value="expected_cash_money", nulls=Nulls.SKIP)
        public Builder expectedCashMoney(Optional<Money> expectedCashMoney) {
            this.expectedCashMoney = expectedCashMoney;
            return this;
        }

        public Builder expectedCashMoney(Money expectedCashMoney) {
            this.expectedCashMoney = Optional.ofNullable(expectedCashMoney);
            return this;
        }

        @JsonSetter(value="closed_cash_money", nulls=Nulls.SKIP)
        public Builder closedCashMoney(Optional<Money> closedCashMoney) {
            this.closedCashMoney = closedCashMoney;
            return this;
        }

        public Builder closedCashMoney(Money closedCashMoney) {
            this.closedCashMoney = Optional.ofNullable(closedCashMoney);
            return this;
        }

        @JsonSetter(value="device", nulls=Nulls.SKIP)
        public Builder device(Optional<CashDrawerDevice> device) {
            this.device = device;
            return this;
        }

        public Builder device(CashDrawerDevice device) {
            this.device = Optional.ofNullable(device);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<String> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @JsonSetter(value="location_id", nulls=Nulls.SKIP)
        public Builder locationId(Optional<String> locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = Optional.ofNullable(locationId);
            return this;
        }

        @JsonSetter(value="team_member_ids", nulls=Nulls.SKIP)
        public Builder teamMemberIds(Optional<List<String>> teamMemberIds) {
            this.teamMemberIds = teamMemberIds;
            return this;
        }

        public Builder teamMemberIds(List<String> teamMemberIds) {
            this.teamMemberIds = Optional.ofNullable(teamMemberIds);
            return this;
        }

        @JsonSetter(value="opening_team_member_id", nulls=Nulls.SKIP)
        public Builder openingTeamMemberId(Optional<String> openingTeamMemberId) {
            this.openingTeamMemberId = openingTeamMemberId;
            return this;
        }

        public Builder openingTeamMemberId(String openingTeamMemberId) {
            this.openingTeamMemberId = Optional.ofNullable(openingTeamMemberId);
            return this;
        }

        @JsonSetter(value="ending_team_member_id", nulls=Nulls.SKIP)
        public Builder endingTeamMemberId(Optional<String> endingTeamMemberId) {
            this.endingTeamMemberId = endingTeamMemberId;
            return this;
        }

        public Builder endingTeamMemberId(String endingTeamMemberId) {
            this.endingTeamMemberId = Optional.ofNullable(endingTeamMemberId);
            return this;
        }

        @JsonSetter(value="closing_team_member_id", nulls=Nulls.SKIP)
        public Builder closingTeamMemberId(Optional<String> closingTeamMemberId) {
            this.closingTeamMemberId = closingTeamMemberId;
            return this;
        }

        public Builder closingTeamMemberId(String closingTeamMemberId) {
            this.closingTeamMemberId = Optional.ofNullable(closingTeamMemberId);
            return this;
        }

        public CashDrawerShift build() {
            return new CashDrawerShift(this.id, this.state, this.openedAt, this.endedAt, this.closedAt, this.description, this.openedCashMoney, this.cashPaymentMoney, this.cashRefundsMoney, this.cashPaidInMoney, this.cashPaidOutMoney, this.expectedCashMoney, this.closedCashMoney, this.device, this.createdAt, this.updatedAt, this.locationId, this.teamMemberIds, this.openingTeamMemberId, this.endingTeamMemberId, this.closingTeamMemberId, this.additionalProperties);
        }
    }
}

