/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CashDrawerEventType;
import com.squareup.square.types.Money;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CashDrawerShiftEvent {
    private final Optional<String> id;
    private final Optional<CashDrawerEventType> eventType;
    private final Optional<Money> eventMoney;
    private final Optional<String> createdAt;
    private final Optional<String> description;
    private final Optional<String> teamMemberId;
    private final Map<String, Object> additionalProperties;

    private CashDrawerShiftEvent(Optional<String> id, Optional<CashDrawerEventType> eventType, Optional<Money> eventMoney, Optional<String> createdAt, Optional<String> description, Optional<String> teamMemberId, Map<String, Object> additionalProperties) {
        this.id = id;
        this.eventType = eventType;
        this.eventMoney = eventMoney;
        this.createdAt = createdAt;
        this.description = description;
        this.teamMemberId = teamMemberId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="event_type")
    public Optional<CashDrawerEventType> getEventType() {
        return this.eventType;
    }

    @JsonProperty(value="event_money")
    public Optional<Money> getEventMoney() {
        return this.eventMoney;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonIgnore
    public Optional<String> getDescription() {
        if (this.description == null) {
            return Optional.empty();
        }
        return this.description;
    }

    @JsonProperty(value="team_member_id")
    public Optional<String> getTeamMemberId() {
        return this.teamMemberId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="description")
    private Optional<String> _getDescription() {
        return this.description;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CashDrawerShiftEvent && this.equalTo((CashDrawerShiftEvent)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CashDrawerShiftEvent other) {
        return this.id.equals(other.id) && this.eventType.equals(other.eventType) && this.eventMoney.equals(other.eventMoney) && this.createdAt.equals(other.createdAt) && this.description.equals(other.description) && this.teamMemberId.equals(other.teamMemberId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.eventType, this.eventMoney, this.createdAt, this.description, this.teamMemberId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<CashDrawerEventType> eventType = Optional.empty();
        private Optional<Money> eventMoney = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<String> teamMemberId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CashDrawerShiftEvent other) {
            this.id(other.getId());
            this.eventType(other.getEventType());
            this.eventMoney(other.getEventMoney());
            this.createdAt(other.getCreatedAt());
            this.description(other.getDescription());
            this.teamMemberId(other.getTeamMemberId());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="event_type", nulls=Nulls.SKIP)
        public Builder eventType(Optional<CashDrawerEventType> eventType) {
            this.eventType = eventType;
            return this;
        }

        public Builder eventType(CashDrawerEventType eventType) {
            this.eventType = Optional.ofNullable(eventType);
            return this;
        }

        @JsonSetter(value="event_money", nulls=Nulls.SKIP)
        public Builder eventMoney(Optional<Money> eventMoney) {
            this.eventMoney = eventMoney;
            return this;
        }

        public Builder eventMoney(Money eventMoney) {
            this.eventMoney = Optional.ofNullable(eventMoney);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        public Builder description(Nullable<String> description) {
            this.description = description.isNull() ? null : (description.isEmpty() ? Optional.empty() : Optional.of(description.get()));
            return this;
        }

        @JsonSetter(value="team_member_id", nulls=Nulls.SKIP)
        public Builder teamMemberId(Optional<String> teamMemberId) {
            this.teamMemberId = teamMemberId;
            return this;
        }

        public Builder teamMemberId(String teamMemberId) {
            this.teamMemberId = Optional.ofNullable(teamMemberId);
            return this;
        }

        public CashDrawerShiftEvent build() {
            return new CashDrawerShiftEvent(this.id, this.eventType, this.eventMoney, this.createdAt, this.description, this.teamMemberId, this.additionalProperties);
        }
    }
}

