/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Money;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CashPaymentDetails {
    private final Money buyerSuppliedMoney;
    private final Optional<Money> changeBackMoney;
    private final Map<String, Object> additionalProperties;

    private CashPaymentDetails(Money buyerSuppliedMoney, Optional<Money> changeBackMoney, Map<String, Object> additionalProperties) {
        this.buyerSuppliedMoney = buyerSuppliedMoney;
        this.changeBackMoney = changeBackMoney;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="buyer_supplied_money")
    public Money getBuyerSuppliedMoney() {
        return this.buyerSuppliedMoney;
    }

    @JsonProperty(value="change_back_money")
    public Optional<Money> getChangeBackMoney() {
        return this.changeBackMoney;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CashPaymentDetails && this.equalTo((CashPaymentDetails)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CashPaymentDetails other) {
        return this.buyerSuppliedMoney.equals(other.buyerSuppliedMoney) && this.changeBackMoney.equals(other.changeBackMoney);
    }

    public int hashCode() {
        return Objects.hash(this.buyerSuppliedMoney, this.changeBackMoney);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static BuyerSuppliedMoneyStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements BuyerSuppliedMoneyStage,
    _FinalStage {
        private Money buyerSuppliedMoney;
        private Optional<Money> changeBackMoney = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CashPaymentDetails other) {
            this.buyerSuppliedMoney(other.getBuyerSuppliedMoney());
            this.changeBackMoney(other.getChangeBackMoney());
            return this;
        }

        @Override
        @JsonSetter(value="buyer_supplied_money")
        public _FinalStage buyerSuppliedMoney(@NotNull Money buyerSuppliedMoney) {
            this.buyerSuppliedMoney = Objects.requireNonNull(buyerSuppliedMoney, "buyerSuppliedMoney must not be null");
            return this;
        }

        @Override
        public _FinalStage changeBackMoney(Money changeBackMoney) {
            this.changeBackMoney = Optional.ofNullable(changeBackMoney);
            return this;
        }

        @Override
        @JsonSetter(value="change_back_money", nulls=Nulls.SKIP)
        public _FinalStage changeBackMoney(Optional<Money> changeBackMoney) {
            this.changeBackMoney = changeBackMoney;
            return this;
        }

        @Override
        public CashPaymentDetails build() {
            return new CashPaymentDetails(this.buyerSuppliedMoney, this.changeBackMoney, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CashPaymentDetails build();

        public _FinalStage changeBackMoney(Optional<Money> var1);

        public _FinalStage changeBackMoney(Money var1);
    }

    public static interface BuyerSuppliedMoneyStage {
        public _FinalStage buyerSuppliedMoney(@NotNull Money var1);

        public Builder from(CashPaymentDetails var1);
    }
}

