/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CatalogEcomSeoData {
    private final Optional<String> pageTitle;
    private final Optional<String> pageDescription;
    private final Optional<String> permalink;
    private final Map<String, Object> additionalProperties;

    private CatalogEcomSeoData(Optional<String> pageTitle, Optional<String> pageDescription, Optional<String> permalink, Map<String, Object> additionalProperties) {
        this.pageTitle = pageTitle;
        this.pageDescription = pageDescription;
        this.permalink = permalink;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getPageTitle() {
        if (this.pageTitle == null) {
            return Optional.empty();
        }
        return this.pageTitle;
    }

    @JsonIgnore
    public Optional<String> getPageDescription() {
        if (this.pageDescription == null) {
            return Optional.empty();
        }
        return this.pageDescription;
    }

    @JsonIgnore
    public Optional<String> getPermalink() {
        if (this.permalink == null) {
            return Optional.empty();
        }
        return this.permalink;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="page_title")
    private Optional<String> _getPageTitle() {
        return this.pageTitle;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="page_description")
    private Optional<String> _getPageDescription() {
        return this.pageDescription;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="permalink")
    private Optional<String> _getPermalink() {
        return this.permalink;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CatalogEcomSeoData && this.equalTo((CatalogEcomSeoData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CatalogEcomSeoData other) {
        return this.pageTitle.equals(other.pageTitle) && this.pageDescription.equals(other.pageDescription) && this.permalink.equals(other.permalink);
    }

    public int hashCode() {
        return Objects.hash(this.pageTitle, this.pageDescription, this.permalink);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> pageTitle = Optional.empty();
        private Optional<String> pageDescription = Optional.empty();
        private Optional<String> permalink = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CatalogEcomSeoData other) {
            this.pageTitle(other.getPageTitle());
            this.pageDescription(other.getPageDescription());
            this.permalink(other.getPermalink());
            return this;
        }

        @JsonSetter(value="page_title", nulls=Nulls.SKIP)
        public Builder pageTitle(Optional<String> pageTitle) {
            this.pageTitle = pageTitle;
            return this;
        }

        public Builder pageTitle(String pageTitle) {
            this.pageTitle = Optional.ofNullable(pageTitle);
            return this;
        }

        public Builder pageTitle(Nullable<String> pageTitle) {
            this.pageTitle = pageTitle.isNull() ? null : (pageTitle.isEmpty() ? Optional.empty() : Optional.of(pageTitle.get()));
            return this;
        }

        @JsonSetter(value="page_description", nulls=Nulls.SKIP)
        public Builder pageDescription(Optional<String> pageDescription) {
            this.pageDescription = pageDescription;
            return this;
        }

        public Builder pageDescription(String pageDescription) {
            this.pageDescription = Optional.ofNullable(pageDescription);
            return this;
        }

        public Builder pageDescription(Nullable<String> pageDescription) {
            this.pageDescription = pageDescription.isNull() ? null : (pageDescription.isEmpty() ? Optional.empty() : Optional.of(pageDescription.get()));
            return this;
        }

        @JsonSetter(value="permalink", nulls=Nulls.SKIP)
        public Builder permalink(Optional<String> permalink) {
            this.permalink = permalink;
            return this;
        }

        public Builder permalink(String permalink) {
            this.permalink = Optional.ofNullable(permalink);
            return this;
        }

        public Builder permalink(Nullable<String> permalink) {
            this.permalink = permalink.isNull() ? null : (permalink.isEmpty() ? Optional.empty() : Optional.of(permalink.get()));
            return this;
        }

        public CatalogEcomSeoData build() {
            return new CatalogEcomSeoData(this.pageTitle, this.pageDescription, this.permalink, this.additionalProperties);
        }
    }
}

