/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CatalogInfoResponseLimits;
import com.squareup.square.types.Error;
import com.squareup.square.types.StandardUnitDescriptionGroup;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CatalogInfoResponse {
    private final Optional<List<Error>> errors;
    private final Optional<CatalogInfoResponseLimits> limits;
    private final Optional<StandardUnitDescriptionGroup> standardUnitDescriptionGroup;
    private final Map<String, Object> additionalProperties;

    private CatalogInfoResponse(Optional<List<Error>> errors, Optional<CatalogInfoResponseLimits> limits, Optional<StandardUnitDescriptionGroup> standardUnitDescriptionGroup, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.limits = limits;
        this.standardUnitDescriptionGroup = standardUnitDescriptionGroup;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="limits")
    public Optional<CatalogInfoResponseLimits> getLimits() {
        return this.limits;
    }

    @JsonProperty(value="standard_unit_description_group")
    public Optional<StandardUnitDescriptionGroup> getStandardUnitDescriptionGroup() {
        return this.standardUnitDescriptionGroup;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CatalogInfoResponse && this.equalTo((CatalogInfoResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CatalogInfoResponse other) {
        return this.errors.equals(other.errors) && this.limits.equals(other.limits) && this.standardUnitDescriptionGroup.equals(other.standardUnitDescriptionGroup);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.limits, this.standardUnitDescriptionGroup);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<CatalogInfoResponseLimits> limits = Optional.empty();
        private Optional<StandardUnitDescriptionGroup> standardUnitDescriptionGroup = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CatalogInfoResponse other) {
            this.errors(other.getErrors());
            this.limits(other.getLimits());
            this.standardUnitDescriptionGroup(other.getStandardUnitDescriptionGroup());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="limits", nulls=Nulls.SKIP)
        public Builder limits(Optional<CatalogInfoResponseLimits> limits) {
            this.limits = limits;
            return this;
        }

        public Builder limits(CatalogInfoResponseLimits limits) {
            this.limits = Optional.ofNullable(limits);
            return this;
        }

        @JsonSetter(value="standard_unit_description_group", nulls=Nulls.SKIP)
        public Builder standardUnitDescriptionGroup(Optional<StandardUnitDescriptionGroup> standardUnitDescriptionGroup) {
            this.standardUnitDescriptionGroup = standardUnitDescriptionGroup;
            return this;
        }

        public Builder standardUnitDescriptionGroup(StandardUnitDescriptionGroup standardUnitDescriptionGroup) {
            this.standardUnitDescriptionGroup = Optional.ofNullable(standardUnitDescriptionGroup);
            return this;
        }

        public CatalogInfoResponse build() {
            return new CatalogInfoResponse(this.errors, this.limits, this.standardUnitDescriptionGroup, this.additionalProperties);
        }
    }
}

